/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.DefaultScriptVariableGenerator;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public abstract class AbstractScriptExecutingMessageProcessor<T>
implements MessageProcessor<T>,
BeanClassLoaderAware,
BeanFactoryAware {
    private final ScriptVariableGenerator scriptVariableGenerator;
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;

    protected AbstractScriptExecutingMessageProcessor() {
        this(new DefaultScriptVariableGenerator());
    }

    protected AbstractScriptExecutingMessageProcessor(ScriptVariableGenerator scriptVariableGenerator) {
        Assert.notNull((Object)scriptVariableGenerator, (String)"scriptVariableGenerator must not be null");
        this.scriptVariableGenerator = scriptVariableGenerator;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected ScriptVariableGenerator getScriptVariableGenerator() {
        return this.scriptVariableGenerator;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Nullable
    public final T processMessage(Message<?> message) {
        ScriptSource source = this.getScriptSource(message);
        Map<String, Object> variables = this.scriptVariableGenerator.generateScriptVariables(message);
        return this.executeScript(source, variables);
    }

    protected abstract ScriptSource getScriptSource(Message<?> var1);

    @Nullable
    protected abstract T executeScript(ScriptSource var1, Map<String, Object> var2);
}

