/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.jsr223;

import java.util.Date;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.ScriptingException;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public abstract class AbstractScriptExecutor
implements ScriptExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ScriptEngine scriptEngine;
    protected final String language;

    protected AbstractScriptExecutor(String language) {
        Assert.hasText((String)language, (String)"language must not be empty");
        this.language = language;
        this.scriptEngine = new ScriptEngineManager().getEngineByName(this.language);
        Assert.notNull((Object)this.scriptEngine, (String)AbstractScriptExecutor.invalidLanguageMessage(this.language));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using script engine : " + this.scriptEngine.getFactory().getEngineName()));
        }
    }

    @Override
    public Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) {
        Object result;
        try {
            String script = scriptSource.getScriptAsString();
            Date start = new Date();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("executing script: " + script));
            }
            SimpleBindings bindings = null;
            if (variables != null && variables.size() > 0) {
                bindings = new SimpleBindings(variables);
                result = this.scriptEngine.eval(script, (Bindings)bindings);
            } else {
                result = this.scriptEngine.eval(script);
            }
            result = this.postProcess(result, this.scriptEngine, script, bindings);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("script executed in " + (new Date().getTime() - start.getTime()) + " ms"));
            }
        }
        catch (Exception e) {
            throw new ScriptingException(e.getMessage(), e);
        }
        return result;
    }

    protected abstract Object postProcess(Object var1, ScriptEngine var2, String var3, Bindings var4);

    private static String invalidLanguageMessage(String language) {
        return ScriptEngineManager.class.getName() + " is unable to create a script engine for language '" + language + "'.\nThis may be due to a missing language implementation or an invalid language name.";
    }
}

