/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import io.rsocket.frame.FrameType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.integration.rsocket.IntegrationRSocketEndpoint;
import org.springframework.integration.rsocket.RSocketInteractionModel;
import org.springframework.messaging.Message;
import org.springframework.messaging.ReactiveMessageHandler;
import org.springframework.messaging.handler.CompositeMessageCondition;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.reactive.SyncHandlerMethodArgumentResolver;
import org.springframework.messaging.rsocket.annotation.support.RSocketFrameTypeMessageCondition;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.util.ReflectionUtils;

class IntegrationRSocketMessageHandler
extends RSocketMessageHandler {
    private static final Method HANDLE_MESSAGE_METHOD = ReflectionUtils.findMethod(ReactiveMessageHandler.class, (String)"handleMessage", (Class[])new Class[]{Message.class});
    protected final boolean messageMappingCompatible;

    IntegrationRSocketMessageHandler() {
        this(false);
    }

    IntegrationRSocketMessageHandler(boolean messageMappingCompatible) {
        this.messageMappingCompatible = messageMappingCompatible;
        if (!this.messageMappingCompatible) {
            this.setHandlerPredicate(clazz -> false);
        }
    }

    public boolean detectEndpoints() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null && this.getHandlerMethods().isEmpty()) {
            return applicationContext.getBeansOfType(IntegrationRSocketEndpoint.class).values().stream().peek(this::addEndpoint).count() > 0L;
        }
        return false;
    }

    public void addEndpoint(IntegrationRSocketEndpoint endpoint) {
        RSocketFrameTypeMessageCondition frameTypeMessageCondition = RSocketFrameTypeMessageCondition.EMPTY_CONDITION;
        RSocketInteractionModel[] interactionModels = endpoint.getInteractionModels();
        if (interactionModels.length > 0) {
            frameTypeMessageCondition = new RSocketFrameTypeMessageCondition((FrameType[])Arrays.stream(interactionModels).map(RSocketInteractionModel::getFrameType).toArray(FrameType[]::new));
        }
        this.registerHandlerMethod(endpoint, HANDLE_MESSAGE_METHOD, new CompositeMessageCondition(new MessageCondition[]{frameTypeMessageCondition, new DestinationPatternsMessageCondition(endpoint.getPath(), this.getRouteMatcher())}));
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        if (this.messageMappingCompatible) {
            this.getArgumentResolverConfigurer().addCustomResolver(new HandlerMethodArgumentResolver[]{new MessageHandlerMethodArgumentResolver()});
            return super.initArgumentResolvers();
        }
        return Collections.singletonList(new MessageHandlerMethodArgumentResolver());
    }

    protected static final class MessageHandlerMethodArgumentResolver
    implements SyncHandlerMethodArgumentResolver {
        protected MessageHandlerMethodArgumentResolver() {
        }

        public boolean supportsParameter(MethodParameter parameter) {
            return Message.class.equals((Object)parameter.getParameterType());
        }

        public Object resolveArgumentValue(MethodParameter parameter, Message<?> message) {
            return message;
        }
    }
}

