/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;

public class RedisQueueOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private static final String QUEUE_NAME_SUFFIX = ".reply";
    private static final int TIMEOUT = 1000;
    private static final IdGenerator DEFAULT_ID_GENERATOR = new AlternativeJdkIdGenerator();
    private static final RedisSerializer<String> STRING_SERIALIZER = new StringRedisSerializer();
    private final RedisTemplate<String, Object> template = new RedisTemplate();
    private final BoundListOperations<String, Object> boundListOps;
    private boolean extractPayload = true;
    private RedisSerializer<?> serializer;
    private boolean serializerExplicitlySet;
    private int receiveTimeout = 1000;

    public RedisQueueOutboundGateway(String queueName, RedisConnectionFactory connectionFactory) {
        Assert.hasText((String)queueName, (String)"'queueName' is required");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.template.setConnectionFactory(connectionFactory);
        this.template.setEnableDefaultSerializer(false);
        this.template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.template.afterPropertiesSet();
        this.boundListOps = this.template.boundListOps((Object)queueName);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        super.setBeanClassLoader(beanClassLoader);
        if (!this.serializerExplicitlySet) {
            this.serializer = new JdkSerializationRedisSerializer(beanClassLoader);
        }
    }

    public void setReceiveTimeout(int timeout) {
        this.receiveTimeout = timeout;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
        this.serializerExplicitlySet = true;
    }

    public String getComponentType() {
        return "redis:queue-outbound-gateway";
    }

    @Nullable
    protected Object handleRequestMessage(Message<?> message) {
        Object value = message;
        if (this.extractPayload) {
            value = message.getPayload();
        }
        Message<?> beforeSerialization = value;
        if (!(value instanceof byte[])) {
            value = value instanceof String && !this.serializerExplicitlySet ? (Object)STRING_SERIALIZER.serialize((Object)((String)value)) : (Object)this.serializer.serialize(value);
        }
        if (value == null) {
            this.logger.debug(() -> "Serializer produced null for " + String.valueOf(beforeSerialization));
            return null;
        }
        String uuid = DEFAULT_ID_GENERATOR.generateId().toString();
        byte[] uuidByte = uuid.getBytes();
        this.boundListOps.leftPush((Object)uuidByte);
        this.template.boundListOps((Object)uuid).leftPush(value);
        BoundListOperations boundListOperations = this.template.boundListOps((Object)(uuid + QUEUE_NAME_SUFFIX));
        byte[] reply = (byte[])boundListOperations.rightPop((long)this.receiveTimeout, TimeUnit.MILLISECONDS);
        if (reply != null && reply.length > 0) {
            return this.createReply(reply);
        }
        return null;
    }

    @Nullable
    private Object createReply(byte[] reply) {
        Object replyMessage = this.serializer.deserialize(reply);
        if (replyMessage == null) {
            return null;
        }
        if (this.extractPayload) {
            return this.getMessageBuilderFactory().withPayload(replyMessage);
        }
        return replyMessage;
    }
}

