/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import java.lang.reflect.Method;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class MqttUtils {
    private static final boolean PAHO_MQTTV3_PRESENT = ClassUtils.isPresent((String)"org.eclipse.paho.client.mqttv3.MqttAsyncClient", null);
    private static final boolean PAHO_MQTTV5_PRESENT = ClassUtils.isPresent((String)"org.eclipse.paho.mqttv5.client.MqttAsyncClient", null);
    private static final Method V3_STOP_RECONNECT_CYCLE_METHOD;
    private static final Method V5_STOP_RECONNECT_CYCLE_METHOD;

    private MqttUtils() {
    }

    public static MqttConnectOptions cloneConnectOptions(MqttConnectOptions options) {
        MqttConnectOptions options2 = new MqttConnectOptions();
        BeanUtils.copyProperties((Object)options, (Object)options2, (String[])new String[]{"password", "serverURIs"});
        if (options.getPassword() != null) {
            options2.setPassword(options.getPassword());
        }
        return options2;
    }

    public static void stopClientReconnectCycle(org.eclipse.paho.client.mqttv3.IMqttAsyncClient client) {
        ReflectionUtils.invokeMethod((Method)V3_STOP_RECONNECT_CYCLE_METHOD, (Object)client);
    }

    public static void stopClientReconnectCycle(IMqttAsyncClient client) {
        ReflectionUtils.invokeMethod((Method)V5_STOP_RECONNECT_CYCLE_METHOD, (Object)client);
    }

    static {
        if (PAHO_MQTTV3_PRESENT) {
            V3_STOP_RECONNECT_CYCLE_METHOD = ReflectionUtils.findMethod(org.eclipse.paho.client.mqttv3.MqttAsyncClient.class, (String)"stopReconnectCycle");
            ReflectionUtils.makeAccessible((Method)V3_STOP_RECONNECT_CYCLE_METHOD);
        } else {
            V3_STOP_RECONNECT_CYCLE_METHOD = null;
        }
        if (PAHO_MQTTV5_PRESENT) {
            V5_STOP_RECONNECT_CYCLE_METHOD = ReflectionUtils.findMethod(MqttAsyncClient.class, (String)"stopReconnectCycle");
            ReflectionUtils.makeAccessible((Method)V5_STOP_RECONNECT_CYCLE_METHOD);
        } else {
            V5_STOP_RECONNECT_CYCLE_METHOD = null;
        }
    }
}

