/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.inbound;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.expression.Expression;
import org.springframework.integration.mongodb.inbound.AbstractMongoDbMessageSource;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveMongoDbMessageSource
extends AbstractMongoDbMessageSource<Publisher<?>> {
    private final @Nullable ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory;
    private ReactiveMongoOperations reactiveMongoTemplate;

    public ReactiveMongoDbMessageSource(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, Expression queryExpression) {
        super(queryExpression);
        Assert.notNull((Object)reactiveMongoDatabaseFactory, (String)"'reactiveMongoDatabaseFactory' must not be null");
        this.reactiveMongoDatabaseFactory = reactiveMongoDatabaseFactory;
    }

    public ReactiveMongoDbMessageSource(ReactiveMongoOperations reactiveMongoTemplate, Expression queryExpression) {
        super(queryExpression);
        Assert.notNull((Object)reactiveMongoTemplate, (String)"'reactiveMongoTemplate' must not be null");
        this.reactiveMongoDatabaseFactory = null;
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }

    public String getComponentType() {
        return "mongo:reactive-inbound-channel-adapter";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.reactiveMongoTemplate == null) {
            Assert.state((this.reactiveMongoDatabaseFactory != null ? 1 : 0) != 0, (String)"'reactiveMongoDatabaseFactory' must not be null if 'reactiveMongoTemplate' is null.");
            ReactiveMongoTemplate template = new ReactiveMongoTemplate(this.reactiveMongoDatabaseFactory, this.getMongoConverter());
            template.setApplicationContext(this.getApplicationContext());
            this.reactiveMongoTemplate = template;
        }
        this.setMongoConverter(this.reactiveMongoTemplate.getConverter());
        this.setInitialized(true);
    }

    public Object doReceive() {
        Assert.isTrue((boolean)this.isInitialized(), (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        Query query = this.evaluateQueryExpression();
        String collectionName = this.evaluateCollectionNameExpression();
        Object result = this.isExpectSingleResult() ? this.reactiveMongoTemplate.findOne(query, this.getEntityClass(), collectionName) : this.reactiveMongoTemplate.find(query, this.getEntityClass(), collectionName);
        result = this.updateIfAny((Publisher<?>)result, collectionName);
        return this.getMessageBuilderFactory().withPayload(result).setHeader("mongo_collectionName", (Object)collectionName);
    }

    private Publisher<?> updateIfAny(Publisher<?> result, String collectionName) {
        Update update = this.evaluateUpdateExpression();
        if (update != null) {
            if (result instanceof Mono) {
                return this.updateSingle((Mono)result, update, collectionName);
            }
            return this.updateMulti((Flux)result, update, collectionName);
        }
        return result;
    }

    private Publisher<?> updateSingle(Mono<?> result, Update update, String collectionName) {
        return result.flatMap(entity -> {
            Pair<String, Object> idPair = this.idForEntity(entity);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)((String)idPair.getFirst())).is(idPair.getSecond()));
            return this.reactiveMongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName).thenReturn(entity);
        });
    }

    private Publisher<?> updateMulti(Flux<?> result, Update update, String collectionName) {
        return result.collectList().flatMapMany(entities -> this.reactiveMongoTemplate.updateMulti(this.getByIdInQuery((Collection<?>)entities), (UpdateDefinition)update, collectionName).thenMany((Publisher)Flux.fromIterable((Iterable)entities)));
    }
}

