/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.outbound;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReactiveMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveMongoDbStoringMessageHandler
extends AbstractReactiveMessageHandler {
    private ReactiveMongoOperations mongoTemplate;
    private @Nullable ReactiveMongoDatabaseFactory mongoDbFactory;
    private @Nullable MongoConverter mongoConverter;
    private StandardEvaluationContext evaluationContext;
    private Expression collectionNameExpression = new LiteralExpression("data");
    private volatile boolean initialized = false;

    public ReactiveMongoDbStoringMessageHandler(ReactiveMongoDatabaseFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"'mongoDbFactory' must not be null");
        this.mongoDbFactory = mongoDbFactory;
    }

    public ReactiveMongoDbStoringMessageHandler(ReactiveMongoOperations mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        this.mongoTemplate = mongoTemplate;
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        Assert.isNull((Object)this.mongoTemplate, (String)"'mongoConverter' can not be set when instance was constructed with MongoTemplate");
        this.mongoConverter = mongoConverter;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"'collectionNameExpression' must not be null");
        this.collectionNameExpression = collectionNameExpression;
    }

    public String getComponentType() {
        return "mongo:reactive-outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.mongoTemplate == null) {
            Assert.state((this.mongoDbFactory != null ? 1 : 0) != 0, (String)"'mongoDbFactory' must not be null if 'mongoTemplate' is null.");
            ReactiveMongoTemplate template = new ReactiveMongoTemplate(this.mongoDbFactory, this.mongoConverter);
            template.setApplicationContext(this.getApplicationContext());
            this.mongoTemplate = template;
        }
        this.initialized = true;
    }

    protected Mono<Void> handleMessageInternal(Message<?> message) {
        Assert.isTrue((boolean)this.initialized, (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        return this.evaluateCollectionNameExpression(message).flatMap(collection -> this.mongoTemplate.save(message.getPayload(), collection)).then();
    }

    private Mono<String> evaluateCollectionNameExpression(Message<?> message) {
        return Mono.fromSupplier(() -> {
            String collectionName = (String)this.collectionNameExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, String.class);
            Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' must not evaluate to null");
            return collectionName;
        });
    }
}

