/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceUtils;
import org.springframework.integration.jpa.support.parametersource.ParameterExpressionEvaluator;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.PositionSupportingParameterSource;
import org.springframework.util.Assert;

public class ExpressionEvaluatingParameterSourceFactory
implements ParameterSourceFactory {
    private static final Log LOGGER = LogFactory.getLog(ExpressionEvaluatingParameterSourceFactory.class);
    private static final Object ERROR = new Object();
    private final ParameterExpressionEvaluator expressionEvaluator = new ParameterExpressionEvaluator();
    private final List<JpaParameter> parameters = new ArrayList<JpaParameter>();

    public ExpressionEvaluatingParameterSourceFactory() {
        this(null);
    }

    public ExpressionEvaluatingParameterSourceFactory(@Nullable BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.expressionEvaluator.setBeanFactory(beanFactory);
        }
    }

    public void setParameters(List<JpaParameter> parameters) {
        Assert.notEmpty(parameters, (String)"parameters must not be null or empty.");
        Assert.noNullElements(parameters, (String)"The provided list (parameters) cannot contain null values.");
        this.parameters.addAll(parameters);
        this.expressionEvaluator.getEvaluationContext().setVariable("staticParameters", ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
    }

    @Override
    public PositionSupportingParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingParameterSource(input, this.parameters, this.expressionEvaluator);
    }

    protected class ExpressionEvaluatingParameterSource
    implements PositionSupportingParameterSource {
        private final Object input;
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final List<JpaParameter> parameters;
        private final Map<String, JpaParameter> parametersMap;
        private final ParameterExpressionEvaluator expressionEvaluator;

        protected ExpressionEvaluatingParameterSource(Object input, List<JpaParameter> parameters, ParameterExpressionEvaluator expressionEvaluator) {
            this.input = input;
            this.expressionEvaluator = expressionEvaluator;
            this.parameters = parameters;
            this.parametersMap = new HashMap<String, JpaParameter>(parameters.size());
            for (JpaParameter parameter : parameters) {
                String name = parameter.getName();
                if (name == null) continue;
                this.parametersMap.put(name, parameter);
            }
            this.values.putAll(ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
        }

        @Override
        public @Nullable Object getValueByPosition(int position) {
            Assert.isTrue((position > 0 ? 1 : 0) != 0, (String)"The position must be non-negative.");
            if (position <= this.parameters.size()) {
                JpaParameter parameter = this.parameters.get(position - 1);
                String parameterName = parameter.getName();
                if (parameterName != null) {
                    return this.getValue(parameterName);
                }
                return this.obtainParameterValue(parameter);
            }
            return null;
        }

        @Override
        public @Nullable Object getValue(String paramName) {
            return this.values.computeIfAbsent(paramName, key -> {
                JpaParameter jpaParameter = this.parametersMap.computeIfAbsent(paramName, name -> {
                    JpaParameter parameter = new JpaParameter(paramName, null, paramName);
                    ExpressionEvaluatingParameterSourceFactory.this.parameters.add(parameter);
                    return parameter;
                });
                return this.obtainParameterValue(jpaParameter);
            });
        }

        private @Nullable Object obtainParameterValue(JpaParameter jpaParameter) {
            Object value = jpaParameter.getValue();
            if (value == null) {
                Assert.notNull((Object)jpaParameter.getExpression(), () -> "One of the 'value' or 'expression' must be provided for 'JpaParameter': " + String.valueOf(jpaParameter));
                Expression expression = this.input instanceof Collection ? jpaParameter.getProjectionExpression() : jpaParameter.getSpelExpression();
                if (expression != null) {
                    value = this.expressionEvaluator.evaluateExpression(expression, this.input);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Resolved expression " + String.valueOf(expression) + " to " + String.valueOf(value)));
                    }
                }
            }
            return value;
        }

        @Override
        public boolean hasValue(String paramName) {
            try {
                Object value = this.getValue(paramName);
                if (ERROR.equals(value)) {
                    return false;
                }
            }
            catch (ExpressionException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Could not evaluate expression", (Throwable)e);
                }
                this.values.put(paramName, ERROR);
                return false;
            }
            return true;
        }
    }
}

