/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.outbound;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.outbound.JpaOutboundGateway;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class JpaOutboundGatewayFactoryBean
extends AbstractFactoryBean<MessageHandler> {
    private final JpaExecutor jpaExecutor;
    private OutboundGatewayType gatewayType = OutboundGatewayType.UPDATING;
    private volatile List<Advice> txAdviceChain;
    private volatile List<Advice> adviceChain;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean producesReply = true;
    private MessageChannel outputChannel;
    private int order;
    private long replyTimeout;
    private volatile boolean requiresReply = false;
    private volatile String componentName;

    public JpaOutboundGatewayFactoryBean(JpaExecutor jpaExecutor) {
        Assert.notNull((Object)jpaExecutor, (String)"jpaExecutor must not be null.");
        this.jpaExecutor = jpaExecutor;
    }

    public void setGatewayType(OutboundGatewayType gatewayType) {
        this.gatewayType = gatewayType;
    }

    public void setTxAdviceChain(List<Advice> txAdviceChain) {
        this.txAdviceChain = txAdviceChain;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setProducesReply(boolean producesReply) {
        this.producesReply = producesReply;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Class<?> getObjectType() {
        return MessageHandler.class;
    }

    protected MessageHandler createInstance() {
        JpaOutboundGateway jpaOutboundGateway = new JpaOutboundGateway(this.jpaExecutor);
        jpaOutboundGateway.setGatewayType(this.gatewayType);
        jpaOutboundGateway.setProducesReply(this.producesReply);
        jpaOutboundGateway.setOutputChannel(this.outputChannel);
        jpaOutboundGateway.setOrder(this.order);
        jpaOutboundGateway.setSendTimeout(this.replyTimeout);
        jpaOutboundGateway.setRequiresReply(this.requiresReply);
        jpaOutboundGateway.setComponentName(this.componentName);
        if (this.adviceChain != null) {
            jpaOutboundGateway.setAdviceChain(this.adviceChain);
        }
        jpaOutboundGateway.setBeanFactory(this.getBeanFactory());
        jpaOutboundGateway.afterPropertiesSet();
        if (!CollectionUtils.isEmpty(this.txAdviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)jpaOutboundGateway);
            if (!CollectionUtils.isEmpty(this.txAdviceChain)) {
                for (Advice advice : this.txAdviceChain) {
                    proxyFactory.addAdvice(advice);
                }
            }
            return (MessageHandler)proxyFactory.getProxy(this.beanClassLoader);
        }
        return jpaOutboundGateway;
    }
}

