/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.config.xml;

import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jpa.config.xml.AbstractJpaOutboundGatewayParser;
import org.springframework.integration.jpa.config.xml.JpaParserUtils;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RetrievingJpaOutboundGatewayParser
extends AbstractJpaOutboundGatewayParser {
    @Override
    protected BeanDefinitionBuilder parseHandler(Element gatewayElement, ParserContext parserContext) {
        String idExpression;
        BeanDefinition maxResultsExpression;
        BeanDefinitionBuilder jpaOutboundGatewayBuilder = super.parseHandler(gatewayElement, parserContext);
        BeanDefinitionBuilder jpaExecutorBuilder = JpaParserUtils.getOutboundGatewayJpaExecutorBuilder(gatewayElement, parserContext);
        BeanDefinition firstResultExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"first-result", (String)"first-result-expression", (ParserContext)parserContext, (Element)gatewayElement, (boolean)false);
        if (firstResultExpression != null) {
            jpaExecutorBuilder.addPropertyValue("firstResultExpression", (Object)firstResultExpression);
        }
        if ((maxResultsExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"max-results", (String)"max-results-expression", (ParserContext)parserContext, (Element)gatewayElement, (boolean)false)) != null) {
            jpaExecutorBuilder.addPropertyValue("maxResultsExpression", (Object)maxResultsExpression);
        }
        if (StringUtils.hasText((String)(idExpression = gatewayElement.getAttribute("id-expression")))) {
            boolean childElementsExist;
            String[] otherAttributes = new String[]{"jpa-query", "native-query", "named-query", "first-result", "first-result-expression", "max-results", "max-results-expression", "delete-in-batch", "expect-single-result", "parameter-source-factory", "use-payload-as-parameter-source"};
            StringBuilder others = new StringBuilder();
            for (String otherAttribute : otherAttributes) {
                if (!gatewayElement.hasAttribute(otherAttribute) || !StringUtils.hasText((String)gatewayElement.getAttribute(otherAttribute))) continue;
                if (others.length() > 0) {
                    others.append(", ");
                }
                others.append(otherAttribute);
            }
            boolean bl = childElementsExist = !CollectionUtils.isEmpty((Collection)DomUtils.getChildElementsByTagName((Element)gatewayElement, (String)"parameter"));
            if (others.length() > 0 || childElementsExist) {
                parserContext.getReaderContext().error((others.length() == 0 ? "" : "'" + others.toString() + "' " + (childElementsExist ? "and " : "")) + (childElementsExist ? "child elements " : "") + "not allowed with an 'id-expression' attribute.", (Object)gatewayElement);
            }
            AbstractBeanDefinition idExpressionDef = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)idExpression).getBeanDefinition();
            jpaExecutorBuilder.addPropertyValue("idExpression", (Object)idExpressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"delete-after-poll");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"flush-after-delete", (String)"flush");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"delete-in-batch");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"expect-single-result");
        AbstractBeanDefinition jpaExecutorBuilderBeanDefinition = jpaExecutorBuilder.getBeanDefinition();
        String gatewayId = this.resolveId(gatewayElement, jpaOutboundGatewayBuilder.getRawBeanDefinition(), parserContext);
        String jpaExecutorBeanName = gatewayId + ".jpaExecutor";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)jpaExecutorBuilderBeanDefinition, jpaExecutorBeanName));
        jpaOutboundGatewayBuilder.addConstructorArgReference(jpaExecutorBeanName);
        jpaOutboundGatewayBuilder.addPropertyValue("gatewayType", (Object)OutboundGatewayType.RETRIEVING);
        return jpaOutboundGatewayBuilder;
    }
}

