/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.integration.jms.config.JmsAdapterParserUtils;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsMessageDrivenEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private static final String DEFAULT_REPLY_DESTINATION_ATTRIB = "default-reply-destination";
    private static final String DEFAULT_REPLY_QUEUE_NAME_ATTRIB = "default-reply-queue-name";
    private static final String DEFAULT_REPLY_TOPIC_NAME_ATTRIB = "default-reply-topic-name";
    private static final String REPLY_TIME_TO_LIVE = "reply-time-to-live";
    private static final String REPLY_PRIORITY = "reply-priority";
    private static final String REPLY_DELIVERY_PERSISTENT = "reply-delivery-persistent";
    private static final String EXPLICIT_QOS_ENABLED_FOR_REPLIES = "explicit-qos-enabled-for-replies";
    private static String[] containerAttributes = new String[]{"connectionFactory", "destination", "destination-name", "destination-resolver", "transaction-manager", "concurrent-consumers", "max-concurrent-consumers", "acknowledge", "max-messages-per-task", "selector", "receive-timeout", "recovery-interval", "idle-consumer-limit", "idle-task-execution-limit", "cache-level", "subscription-durable", "durable-subscription-name", "subscription-shared", "subscription-name", "client-id", "task-executor"};
    private final boolean expectReply;

    public JmsMessageDrivenEndpointParser(boolean expectReply) {
        this.expectReply = expectReply;
    }

    protected String getBeanClassName(Element element) {
        return JmsMessageDrivenEndpoint.class.getName();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!this.expectReply && !element.hasAttribute("channel")) {
            id = id + ".adapter";
        }
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return id;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String containerBeanName = this.parseMessageListenerContainer(element, parserContext, (BeanDefinition)builder.getRawBeanDefinition());
        String listenerBeanName = this.parseMessageListener(element, parserContext, (BeanDefinition)builder.getRawBeanDefinition());
        builder.addConstructorArgReference(containerBeanName);
        builder.addConstructorArgReference(listenerBeanName);
        builder.addConstructorArgValue((Object)this.hasExternalContainer(element));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        String role = element.getAttribute("role");
        if (StringUtils.hasText((String)role)) {
            if (!StringUtils.hasText((String)element.getAttribute("id"))) {
                parserContext.getReaderContext().error("When using 'role', 'id' is required", (Object)element);
            }
            IntegrationNamespaceUtils.putLifecycleInRole((String)role, (String)element.getAttribute("id"), (ParserContext)parserContext);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"acknowledge", (String)"sessionAcknowledgeMode");
    }

    private String parseMessageListenerContainer(Element element, ParserContext parserContext, BeanDefinition adapterBeanDefinition) {
        boolean hasDestinationName;
        String containerClass = element.getAttribute("container-class");
        if (this.hasExternalContainer(element)) {
            if (StringUtils.hasText((String)containerClass)) {
                parserContext.getReaderContext().error("Cannot have both 'container' and 'container-class'", (Object)element);
            }
            for (String containerAttribute : containerAttributes) {
                if (!element.hasAttribute(containerAttribute)) continue;
                parserContext.getReaderContext().error("The '" + containerAttribute + "' attribute should not be provided when specifying a 'container' reference.", (Object)element);
            }
            return element.getAttribute("container");
        }
        BeanDefinitionBuilder builder = StringUtils.hasText((String)containerClass) ? BeanDefinitionBuilder.genericBeanDefinition((String)containerClass) : BeanDefinitionBuilder.genericBeanDefinition(DefaultMessageListenerContainer.class);
        String destinationAttribute = this.expectReply ? "request-destination" : "destination";
        String destinationNameAttribute = this.expectReply ? "request-destination-name" : "destination-name";
        String pubSubDomainAttribute = this.expectReply ? "request-pub-sub-domain" : "pub-sub-domain";
        String destination = element.getAttribute(destinationAttribute);
        String destinationName = element.getAttribute(destinationNameAttribute);
        boolean hasDestination = StringUtils.hasText((String)destination);
        if (!(hasDestination ^ (hasDestinationName = StringUtils.hasText((String)destinationName)))) {
            parserContext.getReaderContext().error("Exactly one of '" + destinationAttribute + "' or '" + destinationNameAttribute + "' is required.", (Object)element);
        }
        builder.addPropertyReference("connectionFactory", JmsAdapterParserUtils.determineConnectionFactoryBeanName(element, parserContext));
        if (hasDestination) {
            builder.addPropertyReference("destination", destination);
        } else {
            builder.addPropertyValue("destinationName", (Object)destinationName);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)pubSubDomainAttribute, (String)"pubSubDomain");
        }
        if (StringUtils.hasText((String)element.getAttribute("subscription-name")) && StringUtils.hasText((String)element.getAttribute("durable-subscription-name"))) {
            parserContext.getReaderContext().error("Only one of 'subscription-name' or 'durable-subscription-name' is allowed.", (Object)element);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"transaction-manager");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"selector", (String)"messageSelector");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-messages-per-task");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"recovery-interval");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-consumer-limit");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-task-execution-limit");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"cache-level");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"subscription-durable");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"durable-subscription-name", (String)"subscriptionName");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"subscription-shared");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"subscription-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"client-id");
        builder.addPropertyValue("autoStartup", (Object)false);
        String beanName = this.adapterBeanNameRoot(element, parserContext, adapterBeanDefinition) + ".container";
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        return beanName;
    }

    private boolean hasExternalContainer(Element element) {
        return element.hasAttribute("container");
    }

    private String parseMessageListener(Element element, ParserContext parserContext, BeanDefinition adapterBeanDefinition) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ChannelPublishingJmsMessageListener.class);
        builder.addPropertyValue("expectReply", (Object)this.expectReply);
        if (this.expectReply) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-channel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"correlation-key");
            int defaults = 0;
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_DESTINATION_ATTRIB))) {
                ++defaults;
            }
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_QUEUE_NAME_ATTRIB))) {
                ++defaults;
            }
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_TOPIC_NAME_ATTRIB))) {
                ++defaults;
            }
            if (defaults > 1) {
                parserContext.getReaderContext().error("At most one of 'default-reply-destination', 'default-reply-queue-name', or 'default-reply-topic-name' may be provided.", (Object)element);
            }
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_DESTINATION_ATTRIB);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_QUEUE_NAME_ATTRIB);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_TOPIC_NAME_ATTRIB);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)REPLY_TIME_TO_LIVE);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)REPLY_PRIORITY);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)REPLY_DELIVERY_PERSISTENT);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)EXPLICIT_QOS_ENABLED_FOR_REPLIES);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
        } else {
            String channelName = element.getAttribute("channel");
            if (!StringUtils.hasText((String)channelName)) {
                channelName = IntegrationNamespaceUtils.createDirectChannel((Element)element, (ParserContext)parserContext);
            }
            builder.addPropertyReference("requestChannel", channelName);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout", (String)"requestTimeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload", (String)"extractRequestPayload");
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"header-mapper");
        String alias = this.adapterBeanNameRoot(element, parserContext, adapterBeanDefinition) + ".listener";
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry());
        BeanComponentDefinition component = new BeanComponentDefinition((BeanDefinition)beanDefinition, beanName, new String[]{alias});
        parserContext.registerBeanComponent(component);
        return beanName;
    }

    private String adapterBeanNameRoot(Element element, ParserContext parserContext, BeanDefinition adapterBeanDefinition) {
        String beanName = element.getAttribute("id");
        if (!StringUtils.hasText((String)beanName)) {
            beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)adapterBeanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return beanName;
    }
}

