/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.inbound;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class StoredProcPollingChannelAdapter
extends AbstractMessageSource<Object> {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;

    public StoredProcPollingChannelAdapter(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    protected @Nullable Object doReceive() {
        Object payload;
        Map<String, Object> resultMap = this.executor.executeStoredProcedure();
        if (resultMap.isEmpty()) {
            payload = null;
        } else if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new MessagingException("Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'.");
            }
            payload = resultMap;
        }
        return payload;
    }

    public String getComponentType() {
        return "stored-proc:inbound-channel-adapter";
    }
}

