/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.outbound.JdbcMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcMessageHandlerParser
extends AbstractOutboundChannelAdapterParser {
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        String query;
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcMessageHandler.class);
        String dataSourceRef = element.getAttribute("data-source");
        String jdbcOperationsRef = element.getAttribute("jdbc-operations");
        boolean refToDataSourceSet = StringUtils.hasText((String)dataSourceRef);
        boolean refToJdbcOperationsSet = StringUtils.hasText((String)jdbcOperationsRef);
        if (refToDataSourceSet && refToJdbcOperationsSet || !refToDataSourceSet && !refToJdbcOperationsSet) {
            parserContext.getReaderContext().error("Exactly one of the attributes data-source or simple-jdbc-operations should be set for the JDBC outbound-channel-adapter", source);
        }
        if (!StringUtils.hasText((String)(query = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"query", (ParserContext)parserContext)))) {
            throw new BeanCreationException("The query attribute is required");
        }
        if (!StringUtils.hasText((String)query)) {
            throw new BeanCreationException("The query attribute is required");
        }
        if (refToDataSourceSet) {
            builder.addConstructorArgReference(dataSourceRef);
        } else {
            builder.addConstructorArgReference(jdbcOperationsRef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"sql-parameter-source-factory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"payload-as-parameter-source", (String)"usePayloadAsParameterSource");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"prepared-statement-setter");
        builder.addConstructorArgValue((Object)query);
        return builder.getBeanDefinition();
    }
}

