/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.dsl.StoredProcExecutorSpec;
import org.springframework.integration.jdbc.inbound.StoredProcPollingChannelAdapter;
import org.springframework.util.Assert;

public class JdbcStoredProcInboundChannelAdapterSpec
extends MessageSourceSpec<JdbcStoredProcInboundChannelAdapterSpec, StoredProcPollingChannelAdapter>
implements ComponentsRegistration {
    private final StoredProcExecutor storedProcExecutor;
    private @Nullable StoredProcExecutorSpec storedProcExecutorSpec;

    protected JdbcStoredProcInboundChannelAdapterSpec(StoredProcExecutorSpec storedProcExecutorSpec) {
        this((StoredProcExecutor)storedProcExecutorSpec.getObject());
        this.storedProcExecutorSpec = storedProcExecutorSpec;
    }

    protected JdbcStoredProcInboundChannelAdapterSpec(StoredProcExecutor storedProcExecutor) {
        this.storedProcExecutor = storedProcExecutor;
        this.storedProcExecutorSpec = null;
        this.target = new StoredProcPollingChannelAdapter(this.storedProcExecutor);
    }

    public JdbcStoredProcInboundChannelAdapterSpec configurerStoredProcExecutor(Consumer<StoredProcExecutorSpec> configurer) {
        Assert.notNull(configurer, (String)"'configurer' must not be null");
        Assert.notNull((Object)((Object)this.storedProcExecutorSpec), (String)"The externally provided 'StoredProcExecutor' cannot be mutated in this spec");
        configurer.accept(this.storedProcExecutorSpec);
        return this;
    }

    public JdbcStoredProcInboundChannelAdapterSpec expectSingleResult(boolean expectSingleResult) {
        ((StoredProcPollingChannelAdapter)((Object)this.target)).setExpectSingleResult(expectSingleResult);
        return this;
    }

    public Map<Object, @Nullable String> getComponentsToRegister() {
        return Collections.singletonMap(this.storedProcExecutor, null);
    }
}

