/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ChannelMessageStorePreparedStatementSetter {
    private final @Nullable SerializingConverter serializer;

    public ChannelMessageStorePreparedStatementSetter(SerializingConverter serializer) {
        Assert.notNull((Object)serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    protected ChannelMessageStorePreparedStatementSetter() {
        this.serializer = null;
    }

    public void setValues(PreparedStatement preparedStatement, Message<?> requestMessage, Object groupId, String region, boolean priorityEnabled) throws SQLException {
        String groupKey = Objects.toString(UUIDConverter.getUUID((Object)groupId), null);
        long createdDate = System.currentTimeMillis();
        String messageId = Objects.toString(UUIDConverter.getUUID((Object)requestMessage.getHeaders().getId()), null);
        preparedStatement.setString(1, messageId);
        preparedStatement.setString(2, groupKey);
        preparedStatement.setString(3, region);
        preparedStatement.setLong(4, createdDate);
        Integer priority = (Integer)requestMessage.getHeaders().get((Object)"priority", Integer.class);
        if (priorityEnabled && priority != null) {
            preparedStatement.setInt(5, priority);
        } else {
            preparedStatement.setNull(5, 2);
        }
        if (this.serializer != null) {
            byte[] messageBytes = this.serializer.convert(requestMessage);
            preparedStatement.setBytes(6, messageBytes);
        }
    }
}

