/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.dsl;

import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.dsl.JdbcInboundChannelAdapterSpec;
import org.springframework.integration.jdbc.dsl.JdbcOutboundChannelAdapterSpec;
import org.springframework.integration.jdbc.dsl.JdbcOutboundGatewaySpec;
import org.springframework.integration.jdbc.dsl.JdbcStoredProcInboundChannelAdapterSpec;
import org.springframework.integration.jdbc.dsl.JdbcStoredProcOutboundChannelAdapterSpec;
import org.springframework.integration.jdbc.dsl.JdbcStoredProcOutboundGatewaySpec;
import org.springframework.integration.jdbc.dsl.StoredProcExecutorSpec;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public final class Jdbc {
    public static JdbcInboundChannelAdapterSpec inboundAdapter(DataSource dataSource, String selectQuery) {
        return Jdbc.inboundAdapter((JdbcOperations)new JdbcTemplate(dataSource), selectQuery);
    }

    public static JdbcInboundChannelAdapterSpec inboundAdapter(JdbcOperations jdbcOperations, String selectQuery) {
        return new JdbcInboundChannelAdapterSpec(jdbcOperations, selectQuery);
    }

    public static JdbcOutboundChannelAdapterSpec outboundAdapter(DataSource dataSource, String updateQuery) {
        return Jdbc.outboundAdapter((JdbcOperations)new JdbcTemplate(dataSource), updateQuery);
    }

    public static JdbcOutboundChannelAdapterSpec outboundAdapter(JdbcOperations jdbcOperations, String updateQuery) {
        return new JdbcOutboundChannelAdapterSpec(jdbcOperations, updateQuery);
    }

    public static JdbcOutboundGatewaySpec outboundGateway(DataSource dataSource, String updateQuery) {
        return Jdbc.outboundGateway((JdbcOperations)new JdbcTemplate(dataSource), updateQuery);
    }

    public static JdbcOutboundGatewaySpec outboundGateway(DataSource dataSource, String updateQuery, String selectQuery) {
        return Jdbc.outboundGateway((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, selectQuery);
    }

    public static JdbcOutboundGatewaySpec outboundGateway(JdbcOperations jdbcOperations, String updateQuery) {
        return Jdbc.outboundGateway(jdbcOperations, updateQuery, null);
    }

    public static JdbcOutboundGatewaySpec outboundGateway(JdbcOperations jdbcOperations, String updateQuery, @Nullable String selectQuery) {
        return new JdbcOutboundGatewaySpec(jdbcOperations, updateQuery, selectQuery);
    }

    public static JdbcStoredProcInboundChannelAdapterSpec storedProcInboundAdapter(DataSource dataSource) {
        return new JdbcStoredProcInboundChannelAdapterSpec(Jdbc.storedProcExecutorSpec(dataSource));
    }

    public static JdbcStoredProcInboundChannelAdapterSpec storedProcInboundAdapter(StoredProcExecutor storedProcExecutor) {
        return new JdbcStoredProcInboundChannelAdapterSpec(storedProcExecutor);
    }

    public static JdbcStoredProcOutboundChannelAdapterSpec storedProcOutboundAdapter(DataSource dataSource) {
        return new JdbcStoredProcOutboundChannelAdapterSpec(Jdbc.storedProcExecutorSpec(dataSource));
    }

    public static JdbcStoredProcOutboundChannelAdapterSpec storedProcOutboundAdapter(StoredProcExecutor storedProcExecutor) {
        return new JdbcStoredProcOutboundChannelAdapterSpec(storedProcExecutor);
    }

    public static JdbcStoredProcOutboundGatewaySpec storedProcOutboundGateway(DataSource dataSource) {
        return new JdbcStoredProcOutboundGatewaySpec(Jdbc.storedProcExecutorSpec(dataSource));
    }

    public static JdbcStoredProcOutboundGatewaySpec storedProcOutboundGateway(StoredProcExecutor storedProcExecutor) {
        return new JdbcStoredProcOutboundGatewaySpec(storedProcExecutor);
    }

    public static StoredProcExecutorSpec storedProcExecutorSpec(DataSource dataSource) {
        return new StoredProcExecutorSpec(dataSource);
    }

    private Jdbc() {
    }
}

