/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcCallOperations;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StoredProcExecutor
implements BeanFactoryAware,
InitializingBean {
    private static final int DEFAULT_CACHE_SIZE = 10;
    private static final float LOAD_FACTOR = 0.75f;
    private final DataSource dataSource;
    private final Lock jdbcCallOperationsMapMonitor = new ReentrantLock();
    private Map<String, RowMapper<?>> returningResultSetRowMappers = new HashMap(0);
    private EvaluationContext evaluationContext;
    private BeanFactory beanFactory;
    private int jdbcCallOperationsCacheSize = 10;
    private Map<String, SimpleJdbcCallOperations> jdbcCallOperationsMap;
    private Expression storedProcedureNameExpression;
    private boolean ignoreColumnMetaData = false;
    private boolean skipUndeclaredResults = true;
    private List<SqlParameter> sqlParameters = new ArrayList<SqlParameter>(0);
    private SqlParameterSourceFactory sqlParameterSourceFactory;
    private Boolean usePayloadAsParameterSource;
    private List<ProcedureParameter> procedureParameters;
    private boolean isFunction = false;
    private boolean returnValueRequired = false;

    public StoredProcExecutor(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.storedProcedureNameExpression, (String)"You must either provide a Stored Procedure Name or a Stored Procedure Name Expression.");
        if (this.procedureParameters != null) {
            if (this.sqlParameterSourceFactory == null) {
                ExpressionEvaluatingSqlParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
                expressionSourceFactory.setBeanFactory(this.beanFactory);
                expressionSourceFactory.setStaticParameters(ProcedureParameter.convertStaticParameters(this.procedureParameters));
                expressionSourceFactory.setParameterExpressions(ProcedureParameter.convertExpressions(this.procedureParameters));
                this.sqlParameterSourceFactory = expressionSourceFactory;
            } else {
                Assert.isInstanceOf(ExpressionEvaluatingSqlParameterSourceFactory.class, (Object)this.sqlParameterSourceFactory, () -> "You are providing 'ProcedureParameters'. Was expecting the provided 'sqlParameterSourceFactory' to be an instance of 'ExpressionEvaluatingSqlParameterSourceFactory', however the provided one is of type '" + this.sqlParameterSourceFactory.getClass().getName() + "'");
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.sqlParameterSourceFactory == null) {
                this.sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
        this.jdbcCallOperationsMap = this.buildJdbcCallOperationsMap();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
    }

    private Map<String, SimpleJdbcCallOperations> buildJdbcCallOperationsMap() {
        return new LinkedHashMap<String, SimpleJdbcCallOperations>(this.jdbcCallOperationsCacheSize + 1, 0.75f, true){
            private static final long serialVersionUID = 3801124242820219131L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, SimpleJdbcCallOperations> eldest) {
                return this.size() > StoredProcExecutor.this.jdbcCallOperationsCacheSize;
            }
        };
    }

    private SimpleJdbcCall createSimpleJdbcCall(String storedProcedureName) {
        SimpleJdbcCall simpleJdbcCall = new SimpleJdbcCall(this.dataSource);
        if (this.isFunction) {
            simpleJdbcCall.withFunctionName(storedProcedureName);
        } else {
            simpleJdbcCall.withProcedureName(storedProcedureName);
        }
        if (this.ignoreColumnMetaData) {
            simpleJdbcCall.withoutProcedureColumnMetaDataAccess();
        }
        simpleJdbcCall.declareParameters(this.sqlParameters.toArray(new SqlParameter[0]));
        if (!this.returningResultSetRowMappers.isEmpty()) {
            for (Map.Entry<String, RowMapper<?>> mapEntry : this.returningResultSetRowMappers.entrySet()) {
                simpleJdbcCall.returningResultSet(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        if (this.returnValueRequired) {
            simpleJdbcCall.withReturnValue();
        }
        simpleJdbcCall.getJdbcTemplate().setSkipUndeclaredResults(this.skipUndeclaredResults);
        return simpleJdbcCall;
    }

    public Map<String, Object> executeStoredProcedure() {
        return this.executeStoredProcedureInternal(new Object(), this.evaluateExpression(null));
    }

    public Map<String, Object> executeStoredProcedure(Message<?> message) {
        Assert.notNull(message, (String)"The message parameter must not be null.");
        Assert.notNull((Object)this.usePayloadAsParameterSource, (String)"Property usePayloadAsParameterSource was Null. Did you call afterPropertiesSet()?");
        Object input = this.usePayloadAsParameterSource != false ? message.getPayload() : message;
        return this.executeStoredProcedureInternal(input, this.evaluateExpression(message));
    }

    private String evaluateExpression(@Nullable Message<?> message) {
        String storedProcedureNameToUse = message == null ? (String)this.storedProcedureNameExpression.getValue(this.evaluationContext, String.class) : (String)this.storedProcedureNameExpression.getValue(this.evaluationContext, message, String.class);
        Assert.hasText((String)storedProcedureNameToUse, () -> "Unable to resolve Stored Procedure/Function name for the provided Expression '" + this.storedProcedureNameExpression.getExpressionString() + "'.");
        return storedProcedureNameToUse;
    }

    private Map<String, Object> executeStoredProcedureInternal(Object input, String storedProcedureName) {
        Assert.notNull((Object)this.sqlParameterSourceFactory, (String)"Property sqlParameterSourceFactory was Null. Did you call afterPropertiesSet()?");
        SimpleJdbcCallOperations localSimpleJdbcCall = this.obtainSimpleJdbcCall(storedProcedureName);
        SqlParameterSource storedProcedureParameterSource = this.sqlParameterSourceFactory.createParameterSource(input);
        return localSimpleJdbcCall.execute(storedProcedureParameterSource);
    }

    private SimpleJdbcCallOperations obtainSimpleJdbcCall(String storedProcedureName) {
        SimpleJdbcCallOperations operations = this.jdbcCallOperationsMap.get(storedProcedureName);
        if (operations == null) {
            this.jdbcCallOperationsMapMonitor.lock();
            try {
                operations = this.jdbcCallOperationsMap.computeIfAbsent(storedProcedureName, this::createSimpleJdbcCall);
            }
            finally {
                this.jdbcCallOperationsMapMonitor.unlock();
            }
        }
        return operations;
    }

    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.ignoreColumnMetaData = ignoreColumnMetaData;
    }

    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        Assert.notEmpty(procedureParameters, (String)"'procedureParameters' must not be null or empty.");
        Assert.noNullElements((Object[])procedureParameters.toArray(), (String)"'procedureParameters' cannot contain null values.");
        this.procedureParameters = procedureParameters;
    }

    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        Assert.notEmpty(sqlParameters, (String)"'sqlParameters' must not be null or empty.");
        Assert.noNullElements((Object[])sqlParameters.toArray(), (String)"'sqlParameters' cannot contain null values.");
        this.sqlParameters = sqlParameters;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        Assert.notNull((Object)sqlParameterSourceFactory, (String)"sqlParameterSourceFactory must not be null.");
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public String getStoredProcedureName() {
        return this.storedProcedureNameExpression instanceof LiteralExpression ? (String)this.storedProcedureNameExpression.getValue(String.class) : null;
    }

    public String getStoredProcedureNameExpressionAsString() {
        return this.storedProcedureNameExpression != null ? this.storedProcedureNameExpression.getExpressionString() : null;
    }

    public void setStoredProcedureName(String storedProcedureName) {
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.storedProcedureNameExpression = new LiteralExpression(storedProcedureName);
    }

    public void setStoredProcedureNameExpression(Expression storedProcedureNameExpression) {
        Assert.notNull((Object)storedProcedureNameExpression, (String)"storedProcedureNameExpression must not be null.");
        this.storedProcedureNameExpression = storedProcedureNameExpression;
    }

    public void setUsePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setIsFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.returnValueRequired = returnValueRequired;
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.skipUndeclaredResults = skipUndeclaredResults;
    }

    public void setReturningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        Assert.notNull(returningResultSetRowMappers, (String)"'returningResultSetRowMappers' must not be null.");
        Assert.noNullElements((Object[])returningResultSetRowMappers.values().toArray(), (String)"'returningResultSetRowMappers' cannot contain null values.");
        this.returningResultSetRowMappers = returningResultSetRowMappers;
    }

    public void setJdbcCallOperationsCacheSize(int jdbcCallOperationsCacheSize) {
        Assert.isTrue((jdbcCallOperationsCacheSize >= 0 ? 1 : 0) != 0, (String)"jdbcCallOperationsCacheSize must not be negative.");
        this.jdbcCallOperationsCacheSize = jdbcCallOperationsCacheSize;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

