/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.util.Assert;

public class TcpNetClientConnectionFactory
extends AbstractClientConnectionFactory {
    private TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();
    private TcpNetConnectionSupport tcpNetConnectionSupport = new DefaultTcpNetConnectionSupport();

    public TcpNetClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    @Override
    protected TcpConnectionSupport buildNewConnection() {
        try {
            Socket socket = this.createSocket(this.getHost(), this.getPort());
            this.setSocketAttributes(socket);
            TcpConnectionSupport connection = this.tcpNetConnectionSupport.createNewConnection(socket, false, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
            connection = this.wrapConnection(connection);
            this.initializeConnection(connection, socket);
            this.getTaskExecutor().execute(connection);
            this.harvestClosedConnections();
            return connection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setTcpNetConnectionSupport(TcpNetConnectionSupport connectionSupport) {
        Assert.notNull((Object)connectionSupport, (String)"'connectionSupport' cannot be null");
        this.tcpNetConnectionSupport = connectionSupport;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }

    @Override
    public void start() {
        this.setActive(true);
        super.start();
    }

    protected Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.tcpSocketFactorySupport.getSocketFactory().createSocket();
        socket.connect(new InetSocketAddress(host, port), (int)this.getConnectTimeout().toMillis());
        return socket;
    }
}

