/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.SocketChannel;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;

public class DefaultTcpNioConnectionSupport
extends AbstractTcpConnectionSupport
implements TcpNioConnectionSupport {
    @Override
    public TcpNioConnection createNewConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) throws Exception {
        if (this.isPushbackCapable()) {
            return new PushBackTcpNioConnection(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName, this.getPushbackBufferSize());
        }
        return new TcpNioConnection(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName);
    }

    private static final class PushBackTcpNioConnection
    extends TcpNioConnection {
        private final int pushbackBufferSize;
        private final String connectionId;
        private volatile PushbackInputStream pushbackStream;
        private volatile InputStream wrapped;

        PushBackTcpNioConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName, int bufferSize) throws Exception {
            super(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName);
            this.pushbackBufferSize = bufferSize;
            this.connectionId = "pushback:" + super.getConnectionId();
        }

        @Override
        protected InputStream inputStream() {
            InputStream wrapped = super.inputStream();
            if (this.pushbackStream == null || wrapped != this.wrapped) {
                this.pushbackStream = new PushbackInputStream(wrapped, this.pushbackBufferSize);
                this.wrapped = wrapped;
            }
            return this.pushbackStream;
        }

        @Override
        public String getConnectionId() {
            return this.connectionId;
        }
    }
}

