/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionCloseEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionExceptionEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnectionOpenEvent;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public abstract class TcpConnectionSupport
implements TcpConnection {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CountDownLatch listenerRegisteredLatch = new CountDownLatch(1);
    private volatile Deserializer deserializer;
    private volatile Serializer serializer;
    private volatile TcpMessageMapper mapper;
    private volatile TcpListener listener;
    private volatile TcpSender sender;
    private final boolean server;
    private volatile String connectionId;
    private final AtomicLong sequence = new AtomicLong();
    private volatile String hostName = "unknown";
    private volatile String hostAddress = "unknown";
    private volatile String connectionFactoryName = "unknown";
    private final ApplicationEventPublisher applicationEventPublisher;
    private final AtomicBoolean closePublished = new AtomicBoolean();
    private final AtomicBoolean exceptionSent = new AtomicBoolean();
    private volatile boolean noReadErrorOnClose;
    private volatile boolean manualListenerRegistration;

    public TcpConnectionSupport() {
        this(null);
    }

    public TcpConnectionSupport(ApplicationEventPublisher applicationEventPublisher) {
        this.server = false;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public TcpConnectionSupport(Socket socket, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) {
        this.server = server;
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress != null) {
            this.hostAddress = inetAddress.getHostAddress();
            this.hostName = lookupHost ? inetAddress.getHostName() : this.hostAddress;
        }
        int port = socket.getPort();
        int localPort = socket.getLocalPort();
        this.connectionId = this.hostName + ":" + port + ":" + localPort + ":" + UUID.randomUUID().toString();
        this.applicationEventPublisher = applicationEventPublisher;
        if (connectionFactoryName != null) {
            this.connectionFactoryName = connectionFactoryName;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New connection " + this.getConnectionId()));
        }
    }

    @Override
    public void close() {
        if (this.sender != null) {
            this.sender.removeDeadConnection(this);
        }
        if (!this.closePublished.getAndSet(true)) {
            this.publishConnectionCloseEvent();
        }
    }

    protected void closeConnection(boolean isException) {
        TcpListener listener = this.getListener();
        if (!(listener instanceof TcpConnectionInterceptor)) {
            this.close();
        } else {
            TcpConnectionInterceptor outerInterceptor = (TcpConnectionInterceptor)listener;
            while (outerInterceptor.getListener() instanceof TcpConnectionInterceptor) {
                outerInterceptor = (TcpConnectionInterceptor)outerInterceptor.getListener();
            }
            outerInterceptor.close();
            if (isException) {
                this.close();
            }
        }
    }

    public TcpMessageMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(TcpMessageMapper mapper) {
        Assert.notNull((Object)mapper, (String)(this.getClass().getName() + " Mapper may not be null"));
        this.mapper = mapper;
        if (this.serializer != null && !(this.serializer instanceof AbstractByteArraySerializer)) {
            mapper.setStringToBytes(false);
        }
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
        if (!(serializer instanceof AbstractByteArraySerializer)) {
            this.mapper.setStringToBytes(false);
        }
    }

    public void registerListener(TcpListener listener) {
        this.listener = listener;
        this.listenerRegisteredLatch.countDown();
    }

    public void enableManualListenerRegistration() {
        this.manualListenerRegistration = true;
        this.listener = new TcpListener(){

            @Override
            public boolean onMessage(Message<?> message) {
                return TcpConnectionSupport.this.getListener().onMessage(message);
            }
        };
    }

    public void registerSender(TcpSender sender) {
        this.sender = sender;
        if (sender != null) {
            sender.addNewConnection(this);
        }
    }

    @Override
    public TcpListener getListener() {
        if (this.manualListenerRegistration) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getConnectionId() + " Waiting for listener registration"));
            }
            this.waitForListenerRegistration();
        }
        return this.listener;
    }

    private void waitForListenerRegistration() {
        try {
            Assert.state((boolean)this.listenerRegisteredLatch.await(1L, TimeUnit.MINUTES), (String)"TcpListener not registered");
            this.manualListenerRegistration = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Interrupted while waiting for listener registration", (Throwable)e);
        }
    }

    public TcpSender getSender() {
        return this.sender;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.sequence.incrementAndGet();
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    protected boolean isNoReadErrorOnClose() {
        return this.noReadErrorOnClose;
    }

    protected void setNoReadErrorOnClose(boolean noReadErrorOnClose) {
        this.noReadErrorOnClose = noReadErrorOnClose;
    }

    protected final void sendExceptionToListener(Exception e) {
        if (!this.exceptionSent.getAndSet(true) && this.getListener() != null) {
            Map<String, String> headers = Collections.singletonMap("ip_connectionId", this.getConnectionId());
            ErrorMessage errorMessage = new ErrorMessage((Throwable)e, headers);
            this.getListener().onMessage((Message<?>)errorMessage);
        }
    }

    protected void publishConnectionOpenEvent() {
        TcpConnectionOpenEvent event = new TcpConnectionOpenEvent(this, this.connectionFactoryName);
        this.doPublish(event);
    }

    protected void publishConnectionCloseEvent() {
        TcpConnectionCloseEvent event = new TcpConnectionCloseEvent(this, this.connectionFactoryName);
        this.doPublish(event);
    }

    protected void publishConnectionExceptionEvent(Throwable t) {
        TcpConnectionExceptionEvent event = new TcpConnectionExceptionEvent(this, this.connectionFactoryName, t);
        this.doPublish(event);
    }

    public void publishEvent(TcpConnectionEvent event) {
        Assert.isTrue((event.getSource() == this ? 1 : 0) != 0, (String)"Can only publish events with this as the source");
        this.doPublish(event);
    }

    private void doPublish(TcpConnectionEvent event) {
        block5: {
            try {
                if (this.applicationEventPublisher == null) {
                    this.logger.warn((Object)("No publisher available to publish " + (Object)((Object)event)));
                } else {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                }
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to publish " + (Object)((Object)event)), (Throwable)e);
                }
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn((Object)("Failed to publish " + (Object)((Object)event) + ":" + e.getMessage()));
            }
        }
    }
}

