/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.integration.mapping.MessageMappingException;

public class ByteArrayStxEtxSerializer
extends AbstractByteArraySerializer {
    public static final int STX = 2;
    public static final int ETX = 3;

    public byte[] deserialize(InputStream inputStream) throws IOException {
        int bite = inputStream.read();
        if (bite < 0) {
            throw new SoftEndOfStreamException("Stream closed between payloads");
        }
        if (bite != 2) {
            throw new MessageMappingException("Expected STX to begin message");
        }
        byte[] buffer = new byte[this.maxMessageSize];
        int n = 0;
        while ((bite = inputStream.read()) != 3) {
            this.checkClosure(bite);
            buffer[n++] = (byte)bite;
            if (n < this.maxMessageSize) continue;
            throw new IOException("ETX not found before max message length: " + this.maxMessageSize);
        }
        byte[] assembledData = new byte[n];
        System.arraycopy(buffer, 0, assembledData, 0, n);
        return assembledData;
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(2);
        outputStream.write(bytes);
        outputStream.write(3);
        outputStream.flush();
    }
}

