/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayCrLfSerializer
extends AbstractByteArraySerializer {
    private static final byte[] CRLF = "\r\n".getBytes();

    public byte[] deserialize(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[this.maxMessageSize];
        int n = this.fillToCrLf(inputStream, buffer);
        byte[] assembledData = this.copyToSizedArray(buffer, n);
        return assembledData;
    }

    public int fillToCrLf(InputStream inputStream, byte[] buffer) throws IOException, SoftEndOfStreamException {
        int n;
        block3: {
            n = 0;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Available to read:" + inputStream.available()));
            }
            do {
                int bite;
                if ((bite = inputStream.read()) < 0 && n == 0) {
                    throw new SoftEndOfStreamException("Stream closed between payloads");
                }
                this.checkClosure(bite);
                if (n > 0 && bite == 10 && buffer[n - 1] == 13) break block3;
                buffer[n++] = (byte)bite;
            } while (n < this.maxMessageSize);
            throw new IOException("CRLF not found before max message length: " + this.maxMessageSize);
        }
        return n - 1;
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        outputStream.write(CRLF);
        outputStream.flush();
    }
}

