/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.dsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.expression.Expression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class HttpInboundEndpointSupportSpec<S extends HttpInboundEndpointSupportSpec<S, E>, E extends BaseHttpInboundEndpoint>
extends MessagingGatewaySpec<S, E>
implements ComponentsRegistration {
    protected final RequestMapping requestMapping = new RequestMapping();
    protected final Map<String, Expression> headerExpressions = new HashMap<String, Expression>();
    protected final HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private @Nullable HeaderMapper<HttpHeaders> explicitHeaderMapper;

    protected HttpInboundEndpointSupportSpec(E gateway, String ... path) {
        super(gateway);
        this.requestMapping.setPathPatterns(path);
        ((BaseHttpInboundEndpoint)((Object)this.target)).setRequestMapping(this.requestMapping);
        ((BaseHttpInboundEndpoint)((Object)this.target)).setHeaderExpressions(this.headerExpressions);
        ((BaseHttpInboundEndpoint)((Object)this.target)).setHeaderMapper(this.headerMapper);
    }

    public S requestMapping(Consumer<RequestMappingSpec> mapping) {
        mapping.accept(new RequestMappingSpec(this.requestMapping));
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S crossOrigin(Consumer<CrossOriginSpec> crossOrigin) {
        CrossOriginSpec originSpec = new CrossOriginSpec();
        crossOrigin.accept(originSpec);
        ((BaseHttpInboundEndpoint)((Object)this.target)).setCrossOrigin(originSpec.crossOrigin);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S payloadExpression(String payloadExpression) {
        return this.payloadExpression(PARSER.parseExpression(payloadExpression));
    }

    public S payloadExpression(Expression payloadExpression) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setPayloadExpression(payloadExpression);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public <P> S payloadFunction(Function<HttpEntity<P>, ?> payloadFunction) {
        return this.payloadExpression((Expression)new FunctionExpression(payloadFunction));
    }

    public S headerExpressions(Map<String, Expression> expressions) {
        Assert.notNull(expressions, (String)"'headerExpressions' must not be null");
        this.headerExpressions.clear();
        this.headerExpressions.putAll(expressions);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S headerExpression(String header, String expression) {
        return this.headerExpression(header, PARSER.parseExpression(expression));
    }

    public S headerExpression(String header, Expression expression) {
        this.headerExpressions.put(header, expression);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public <P> S headerFunction(String header, Function<HttpEntity<P>, ?> headerFunction) {
        return this.headerExpression(header, (Expression)new FunctionExpression(headerFunction));
    }

    public S headerMapper(HeaderMapper<HttpHeaders> mapper) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setHeaderMapper(mapper);
        this.explicitHeaderMapper = mapper;
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S mappedRequestHeaders(String ... patterns) {
        Assert.isNull(this.explicitHeaderMapper, () -> "The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + String.valueOf(this.explicitHeaderMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setInboundHeaderNames(patterns);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S mappedResponseHeaders(String ... patterns) {
        Assert.isNull(this.explicitHeaderMapper, () -> "The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + String.valueOf(this.explicitHeaderMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setOutboundHeaderNames(patterns);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S requestPayloadType(Class<?> requestPayloadType) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setRequestPayloadTypeClass(requestPayloadType);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S requestPayloadType(ResolvableType requestPayloadType) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setRequestPayloadType(requestPayloadType);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S extractReplyPayload(boolean extractReplyPayload) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setExtractReplyPayload(extractReplyPayload);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S statusCodeExpression(String statusCodeExpression) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setStatusCodeExpressionString(statusCodeExpression);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S statusCodeExpression(Expression statusCodeExpression) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setStatusCodeExpression(statusCodeExpression);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public S statusCodeFunction(Function<RequestEntity<?>, ?> statusCodeFunction) {
        return this.statusCodeExpression((Expression)new FunctionExpression(statusCodeFunction));
    }

    public S validator(Validator validator) {
        ((BaseHttpInboundEndpoint)((Object)this.target)).setValidator(validator);
        return (S)((Object)((HttpInboundEndpointSupportSpec)this._this()));
    }

    public Map<Object, @Nullable String> getComponentsToRegister() {
        HeaderMapper<HttpHeaders> headerMapperToRegister = this.explicitHeaderMapper != null ? this.explicitHeaderMapper : this.headerMapper;
        return Collections.singletonMap(headerMapperToRegister, null);
    }

    public static final class RequestMappingSpec {
        private final RequestMapping requestMapping;

        RequestMappingSpec(RequestMapping requestMapping) {
            this.requestMapping = requestMapping;
        }

        public RequestMappingSpec methods(HttpMethod ... supportedMethods) {
            this.requestMapping.setMethods(supportedMethods);
            return this;
        }

        public RequestMappingSpec params(String ... params) {
            this.requestMapping.setParams(params);
            return this;
        }

        public RequestMappingSpec headers(String ... headers) {
            this.requestMapping.setHeaders(headers);
            return this;
        }

        public RequestMappingSpec consumes(String ... consumes) {
            this.requestMapping.setConsumes(consumes);
            return this;
        }

        public RequestMappingSpec produces(String ... produces) {
            this.requestMapping.setProduces(produces);
            return this;
        }
    }

    public static final class CrossOriginSpec {
        private final CrossOrigin crossOrigin = new CrossOrigin();

        CrossOriginSpec() {
        }

        public CrossOriginSpec origin(String ... origin) {
            this.crossOrigin.setOrigin(origin);
            return this;
        }

        public CrossOriginSpec allowedHeaders(String ... allowedHeaders) {
            this.crossOrigin.setAllowedHeaders(allowedHeaders);
            return this;
        }

        public CrossOriginSpec exposedHeaders(String ... exposedHeaders) {
            this.crossOrigin.setExposedHeaders(exposedHeaders);
            return this;
        }

        public CrossOriginSpec method(RequestMethod ... method) {
            this.crossOrigin.setMethod(method);
            return this;
        }

        public CrossOriginSpec allowCredentials(Boolean allowCredentials) {
            this.crossOrigin.setAllowCredentials(allowCredentials);
            return this;
        }

        public CrossOriginSpec maxAge(long maxAge) {
            this.crossOrigin.setMaxAge(maxAge);
            return this;
        }
    }
}

