/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.management;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.support.management.ControlBusCommandRegistry;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/control-bus"})
public class ControlBusController
implements BeanFactoryAware,
InitializingBean {
    private final ControlBusCommandRegistry controlBusCommandRegistry;
    private final FormattingConversionService conversionService;
    private BeanFactory beanFactory;
    private EvaluationContext evaluationContext;

    public ControlBusController(ControlBusCommandRegistry controlBusCommandRegistry, FormattingConversionService conversionService) {
        this.controlBusCommandRegistry = controlBusCommandRegistry;
        this.conversionService = conversionService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.beanFactory);
    }

    @GetMapping(name="getCommands")
    public List<ControlBusBean> getCommands() {
        return this.controlBusCommandRegistry.getCommands().entrySet().stream().map(beanEntry -> ControlBusController.createControlBusBean((String)beanEntry.getKey(), (Map)beanEntry.getValue())).toList();
    }

    @PostMapping(name="invokeCommand", path={"/{command}"})
    public @Nullable Object invokeCommand(@PathVariable String command, @RequestBody(required=false) List<CommandArgument> arguments) {
        Class[] parameterTypes = new Class[]{};
        if (!CollectionUtils.isEmpty(arguments)) {
            parameterTypes = (Class[])arguments.stream().map(CommandArgument::parameterType).toArray(Class[]::new);
        }
        Expression commandExpression = this.controlBusCommandRegistry.getExpressionForCommand(command, parameterTypes);
        A[] parameterValues = null;
        if (!CollectionUtils.isEmpty(arguments)) {
            parameterValues = arguments.stream().map(arg -> this.conversionService.convert((Object)arg.value, arg.parameterType)).toArray(Object[]::new);
        }
        return commandExpression.getValue(this.evaluationContext, parameterValues);
    }

    private static ControlBusBean createControlBusBean(String beanName, Map<ControlBusCommandRegistry.CommandMethod, String> commandsForBean) {
        List<ControlBusCommand> commands = commandsForBean.keySet().stream().map(ControlBusController::converControlBusCommand).toList();
        return new ControlBusBean(beanName, commands);
    }

    private static ControlBusCommand converControlBusCommand(ControlBusCommandRegistry.CommandMethod commandMethod) {
        return new ControlBusCommand(commandMethod.getBeanName() + "." + commandMethod.getMethodName(), commandMethod.getDescription(), Arrays.asList(commandMethod.getParameterTypes()));
    }

    public record ControlBusBean(String beanName, List<ControlBusCommand> commands) {
    }

    public record ControlBusCommand(String command, String description, List<Class<?>> parameterTypes) {
    }

    public record CommandArgument(String value, Class<?> parameterType) {
    }
}

