/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.multipart;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class UploadedMultipartFile
implements MultipartFile {
    private final @Nullable File file;
    private final byte @Nullable [] bytes;
    private final long size;
    private final @Nullable String contentType;
    private final String formParameterName;
    private final @Nullable String originalFilename;

    public UploadedMultipartFile(File file, long size, @Nullable String contentType, String formParameterName, @Nullable String originalFilename) {
        Assert.notNull((Object)file, (String)"file must not be null");
        Assert.hasText((String)contentType, (String)"contentType is required");
        Assert.hasText((String)formParameterName, (String)"formParameterName is required");
        Assert.hasText((String)originalFilename, (String)"originalFilename is required");
        this.file = file;
        this.size = size;
        this.bytes = null;
        this.contentType = contentType;
        this.formParameterName = formParameterName;
        this.originalFilename = originalFilename;
    }

    public UploadedMultipartFile(byte[] bytes, @Nullable String contentType, String formParameterName, @Nullable String originalFilename) {
        Assert.notNull((Object)bytes, (String)"bytes must not be null");
        Assert.hasText((String)contentType, (String)"contentType is required");
        Assert.hasText((String)formParameterName, (String)"formParameterName is required");
        Assert.hasText((String)originalFilename, (String)"originalFilename is required");
        this.bytes = bytes;
        this.size = bytes.length;
        this.file = null;
        this.contentType = contentType;
        this.formParameterName = formParameterName;
        this.originalFilename = originalFilename;
    }

    public String getName() {
        return this.formParameterName;
    }

    public byte[] getBytes() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        return FileCopyUtils.copyToByteArray((File)this.file);
    }

    public @Nullable String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public @Nullable String getOriginalFilename() {
        return this.originalFilename;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (this.bytes != null) {
            FileCopyUtils.copy((byte[])this.bytes, (File)dest);
        } else {
            FileCopyUtils.copy((File)this.file, (File)dest);
        }
    }
}

