/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.integration.http.multipart.DefaultMultipartFileReader;
import org.springframework.integration.http.multipart.MultipartFileReader;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class MultipartAwareFormHttpMessageConverter
implements HttpMessageConverter<MultiValueMap<String, ?>> {
    private final FormHttpMessageConverter wrappedConverter = new AllEncompassingFormHttpMessageConverter();
    private MultipartFileReader<?> multipartFileReader = new DefaultMultipartFileReader();

    public void setCharset(Charset charset) {
        this.wrappedConverter.setCharset(charset);
    }

    public void setMultipartFileReader(MultipartFileReader<?> multipartFileReader) {
        Assert.notNull(multipartFileReader, (String)"'multipartFileReader' must not be null");
        this.multipartFileReader = multipartFileReader;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.wrappedConverter.getSupportedMediaTypes();
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz) && !byte[].class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType != null) {
            return MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType) || MediaType.MULTIPART_FORM_DATA.includes(mediaType);
        }
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.wrappedConverter.canWrite(clazz, mediaType);
    }

    public MultiValueMap<String, ?> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (!MediaType.MULTIPART_FORM_DATA.includes(contentType)) {
            return this.wrappedConverter.read(clazz, inputMessage);
        }
        Assert.state((boolean)(inputMessage instanceof MultipartHttpInputMessage), (String)"A request with 'multipart/form-data' Content-Type must be a MultipartHttpInputMessage. Be sure to provide a 'multipartResolver' bean in the ApplicationContext.");
        return this.readMultipart((MultipartHttpInputMessage)inputMessage);
    }

    private MultiValueMap<String, ?> readMultipart(MultipartHttpInputMessage multipartRequest) throws IOException {
        LinkedMultiValueMap resultMap = new LinkedMultiValueMap();
        MultiValueMap<String, String> parameterMap = multipartRequest.getParameterMap();
        parameterMap.forEach((arg_0, arg_1) -> ((MultiValueMap)resultMap).addAll(arg_0, arg_1));
        for (Map.Entry entry : multipartRequest.getMultiFileMap().entrySet()) {
            List multipartFiles = (List)entry.getValue();
            for (MultipartFile multipartFile : multipartFiles) {
                if (multipartFile.isEmpty()) continue;
                resultMap.add((Object)((String)entry.getKey()), this.multipartFileReader.readMultipartFile(multipartFile));
            }
        }
        return resultMap;
    }

    public void write(MultiValueMap<String, ?> map, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.wrappedConverter.write(map, contentType, outputMessage);
    }
}

