/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.util.HashMap;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public final class HttpContextUtils {
    public static final boolean WEB_MVC_PRESENT = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)HttpContextUtils.class.getClassLoader());
    public static final boolean WEB_FLUX_PRESENT = ClassUtils.isPresent((String)"org.springframework.web.reactive.DispatcherHandler", (ClassLoader)HttpContextUtils.class.getClassLoader());
    public static final String HANDLER_MAPPING_BEAN_NAME = "integrationRequestMappingHandlerMapping";
    public static final String GRAPH_CONTROLLER_PATH_PROPERTY = "spring.integration.graph.controller.request.mapping.path";
    public static final String GRAPH_CONTROLLER_DEFAULT_PATH = "/integration";
    public static final String GRAPH_CONTROLLER_BEAN_NAME = "integrationGraphController";

    private HttpContextUtils() {
    }

    public static org.springframework.web.bind.annotation.RequestMapping convertRequestMappingToAnnotation(RequestMapping requestMapping) {
        if (ObjectUtils.isEmpty((Object[])requestMapping.getPathPatterns())) {
            return null;
        }
        HashMap<String, Object> requestMappingAttributes = new HashMap<String, Object>();
        requestMappingAttributes.put("name", requestMapping.getName());
        requestMappingAttributes.put("value", requestMapping.getPathPatterns());
        requestMappingAttributes.put("path", requestMapping.getPathPatterns());
        requestMappingAttributes.put("method", requestMapping.getRequestMethods());
        requestMappingAttributes.put("params", requestMapping.getParams());
        requestMappingAttributes.put("headers", requestMapping.getHeaders());
        requestMappingAttributes.put("consumes", requestMapping.getConsumes());
        requestMappingAttributes.put("produces", requestMapping.getProduces());
        return (org.springframework.web.bind.annotation.RequestMapping)AnnotationUtils.synthesizeAnnotation(requestMappingAttributes, org.springframework.web.bind.annotation.RequestMapping.class, null);
    }
}

