/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    private static final String PACKAGE_PATH = "org.springframework.integration.http";

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        String defaultUrl = element.getAttribute("default-url");
        String charset = element.getAttribute("charset");
        String extractPayload = element.getAttribute("extract-request-payload");
        String requestMapperRef = element.getAttribute("request-mapper");
        if (StringUtils.hasText((String)requestMapperRef)) {
            if (StringUtils.hasText((String)defaultUrl)) {
                this.requestMapperConflictError("default-url", parserContext, element);
                return null;
            }
            if (StringUtils.hasText((String)charset)) {
                this.requestMapperConflictError("charset", parserContext, element);
                return null;
            }
            if (StringUtils.hasText((String)extractPayload)) {
                this.requestMapperConflictError("extract-request-payload", parserContext, element);
                return null;
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.HttpOutboundEndpoint");
        if (!StringUtils.hasText((String)requestMapperRef)) {
            BeanDefinitionBuilder mapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.DefaultOutboundRequestMapper");
            if (StringUtils.hasText((String)defaultUrl)) {
                mapperBuilder.addConstructorArgValue((Object)defaultUrl);
            }
            if (StringUtils.hasText((String)charset)) {
                mapperBuilder.addPropertyValue("charset", (Object)charset);
            }
            if (StringUtils.hasText((String)extractPayload)) {
                mapperBuilder.addPropertyValue("extractPayload", (Object)extractPayload);
            }
            requestMapperRef = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mapperBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        builder.addPropertyReference("requestMapper", requestMapperRef);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-executor");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        return builder;
    }

    private void requestMapperConflictError(String nameForGateway, ParserContext parserContext, Element element) {
        parserContext.getReaderContext().error("The '" + nameForGateway + "' and 'request-mapper' are mutually exclusive. " + "When providing an OutboundRequestMapper, set any corresponding property on the mapper directly.", (Object)element);
    }
}

