/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.URL;
import org.springframework.integration.core.Message;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ReplyMessageHolder;
import org.springframework.integration.http.DefaultOutboundRequestMapper;
import org.springframework.integration.http.HttpRequest;
import org.springframework.integration.http.HttpRequestExecutor;
import org.springframework.integration.http.HttpResponse;
import org.springframework.integration.http.OutboundRequestMapper;
import org.springframework.integration.http.SimpleHttpRequestExecutor;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpOutboundEndpoint
extends AbstractReplyProducingMessageHandler {
    private volatile OutboundRequestMapper requestMapper;
    private volatile HttpRequestExecutor requestExecutor = new SimpleHttpRequestExecutor();

    public HttpOutboundEndpoint() {
        this.requestMapper = new DefaultOutboundRequestMapper();
    }

    public HttpOutboundEndpoint(URL defaultUrl) {
        this.requestMapper = new DefaultOutboundRequestMapper(defaultUrl);
    }

    public void setRequestMapper(OutboundRequestMapper requestMapper) {
        Assert.notNull((Object)requestMapper, (String)"requestMapper must not be null");
        this.requestMapper = requestMapper;
    }

    public void setRequestExecutor(HttpRequestExecutor requestExecutor) {
        Assert.notNull((Object)requestExecutor, (String)"requestExecutor must not be null");
        this.requestExecutor = requestExecutor;
    }

    protected void handleRequestMessage(Message<?> requestMessage, ReplyMessageHolder replyMessageHolder) {
        try {
            HttpRequest request = (HttpRequest)this.requestMapper.fromMessage(requestMessage);
            HttpResponse response = this.requestExecutor.executeRequest(request);
            Object reply = this.createReplyFromResponse(response);
            replyMessageHolder.set(reply);
        }
        catch (Exception e) {
            throw new MessageHandlingException(requestMessage, "failed to execute HTTP request", (Throwable)e);
        }
    }

    private Object createReplyFromResponse(HttpResponse response) throws Exception {
        InputStream responseBody = response.getBody();
        Assert.notNull((Object)responseBody, (String)"received null response body");
        String contentType = response.getFirstHeader("Content-Type");
        if (contentType != null && contentType.startsWith("application/x-java-serialized-object")) {
            return this.deserializePayload(responseBody);
        }
        ByteArrayOutputStream responseByteStream = new ByteArrayOutputStream();
        FileCopyUtils.copy((InputStream)responseBody, (OutputStream)responseByteStream);
        if (contentType != null && contentType.startsWith("text")) {
            String charsetName = this.getCharsetName(response);
            if (charsetName == null) {
                charsetName = "ISO-8859-1";
            }
            return responseByteStream.toString(charsetName);
        }
        return responseByteStream.toByteArray();
    }

    private String getCharsetName(HttpResponse httpResponse) {
        int beginIndex;
        String contentType = httpResponse.getFirstHeader("Content-Type");
        if (contentType != null && (beginIndex = contentType.indexOf("charset=")) != -1) {
            return contentType.substring(beginIndex + "charset=".length()).trim();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object deserializePayload(InputStream responseBody) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectStream = null;
        try {
            objectStream = new ObjectInputStream(responseBody);
            object = objectStream.readObject();
        }
        catch (ObjectStreamException e) {
            try {
                throw new IllegalArgumentException("failed to deserialize response", e);
            }
            catch (Throwable throwable) {
                try {
                    objectStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            objectStream.close();
            return object;
        }
        catch (Exception exception) {}
        return object;
    }
}

