/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.integration.core.Message;
import org.springframework.integration.gateway.SimpleMessagingGateway;
import org.springframework.integration.http.DefaultInboundRequestMapper;
import org.springframework.integration.http.InboundRequestMapper;
import org.springframework.integration.http.ResponseStatusCodeException;
import org.springframework.integration.message.MessageTimeoutException;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpInboundEndpoint
extends SimpleMessagingGateway
implements HttpRequestHandler {
    private static final String DEFAULT_REQUEST_KEY = "requestMessage";
    private static final String DEFAULT_REPLY_KEY = "reply";
    private volatile List<String> supportedMethods = Arrays.asList("GET", "POST");
    private volatile boolean expectReply;
    private volatile InboundRequestMapper requestMapper;
    private volatile boolean extractReplyPayload = true;
    private volatile View view;
    private volatile String requestKey = "requestMessage";
    private volatile String replyKey = "reply";

    public void setSupportedMethods(String ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        int i = 0;
        while (i < supportedMethods.length) {
            supportedMethods[i] = supportedMethods[i].trim().toUpperCase();
            ++i;
        }
        this.supportedMethods = Arrays.asList(supportedMethods);
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setRequestMapper(InboundRequestMapper requestMapper) {
        Assert.notNull((Object)requestMapper, (String)"requestMapper must not be null");
        this.requestMapper = requestMapper;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey != null ? requestKey : DEFAULT_REQUEST_KEY;
    }

    public void setReplyKey(String replyKey) {
        this.replyKey = replyKey != null ? replyKey : DEFAULT_REPLY_KEY;
    }

    protected void onInit() throws Exception {
        if (this.requestMapper == null) {
            this.configureDefaultRequestMapper();
        }
        super.onInit();
    }

    private void configureDefaultRequestMapper() {
        DefaultInboundRequestMapper defaultMapper;
        block4: {
            defaultMapper = new DefaultInboundRequestMapper();
            if (this.getBeanFactory() != null) {
                try {
                    MultipartResolver multipartResolver = (MultipartResolver)this.getBeanFactory().getBean("multipartResolver", MultipartResolver.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
                    }
                    defaultMapper.setMultipartResolver(multipartResolver);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
                }
            }
        }
        this.requestMapper = defaultMapper;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.notNull((Object)this.requestMapper, (String)"HttpInboundEndpoint has not been initialized.");
        if (!this.supportedMethods.contains(request.getMethod())) {
            response.setStatus(405);
            return;
        }
        try {
            Message requestMessage = this.requestMapper.toMessage(request);
            Object reply = this.handleRequestMessage(requestMessage);
            this.generateResponse(requestMessage, reply, request, response);
        }
        catch (ResponseStatusCodeException e) {
            response.setStatus(e.getStatusCode());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Object handleRequestMessage(Message<?> requestMessage) {
        Object reply = null;
        if (this.expectReply) {
            reply = this.extractReplyPayload ? this.sendAndReceive(requestMessage) : this.sendAndReceiveMessage(requestMessage);
            if (reply == null) {
                throw new MessageTimeoutException(requestMessage, "failed to handle Message within specified timeout value");
            }
        } else {
            this.send(requestMessage);
        }
        return reply;
    }

    private void generateResponse(Message<?> requestMessage, Object reply, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.view != null) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put(this.requestKey, requestMessage);
            if (reply != null) {
                model.put(this.replyKey, reply);
            }
            try {
                this.view.render(model, httpRequest, httpResponse);
            }
            catch (Exception e) {
                throw new ServletException("failed to render view", (Throwable)e);
            }
        } else if (reply == null) {
            httpResponse.setStatus(200);
        } else if (reply instanceof String) {
            httpResponse.setContentType("text/plain");
            httpResponse.setContentLength(((String)reply).length());
            httpResponse.getWriter().print((String)reply);
            httpResponse.flushBuffer();
        } else if (reply instanceof byte[]) {
            byte[] bytes = (byte[])reply;
            httpResponse.setContentType("application/octet-stream");
            httpResponse.setContentLength(bytes.length);
            httpResponse.getOutputStream().write(bytes);
            httpResponse.flushBuffer();
        } else if (reply instanceof Serializable) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(reply);
            objectStream.flush();
            objectStream.close();
            byte[] bytes = byteStream.toByteArray();
            httpResponse.getOutputStream().write(bytes);
            httpResponse.setContentType("application/x-java-serialized-object");
            httpResponse.setContentLength(bytes.length);
            httpResponse.flushBuffer();
        } else {
            throw new ServletException("failed to generate HTTP response from reply Message");
        }
    }
}

