/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.hazelcast.inbound.HazelcastContinuousQueryMessageProducer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HazelcastContinuousQueryInboundChannelAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CHANNEL_ATTRIBUTE = "channel";
    private static final String CACHE_ATTRIBUTE = "cache";
    private static final String CACHE_EVENTS_ATTRIBUTE = "cache-events";
    private static final String PREDICATE_ATTRIBUTE = "predicate";
    private static final String INCLUDE_VALUE_ATTRIBUTE = "include-value";
    private static final String CACHE_LISTENING_POLICY_ATTRIBUTE = "cache-listening-policy";
    private static final String OUTPUT_CHANNEL = "outputChannel";
    private static final String CACHE_EVENT_TYPES = "cacheEventTypes";

    protected Class<?> getBeanClass(Element element) {
        return HazelcastContinuousQueryMessageProducer.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        Object id = super.resolveId(element, definition, parserContext);
        if (!element.hasAttribute(CHANNEL_ATTRIBUTE)) {
            id = (String)id + ".adapter";
        }
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return id;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String channelName = element.getAttribute(CHANNEL_ATTRIBUTE);
        if (!StringUtils.hasText((String)channelName)) {
            channelName = IntegrationNamespaceUtils.createDirectChannel((Element)element, (ParserContext)parserContext);
        }
        if (!StringUtils.hasText((String)element.getAttribute(CACHE_ATTRIBUTE))) {
            HazelcastContinuousQueryInboundChannelAdapterParser.errorAttributeRequired(element, parserContext, CACHE_ATTRIBUTE);
        } else if (!StringUtils.hasText((String)element.getAttribute(CACHE_EVENTS_ATTRIBUTE))) {
            HazelcastContinuousQueryInboundChannelAdapterParser.errorAttributeRequired(element, parserContext, CACHE_EVENTS_ATTRIBUTE);
        } else if (!StringUtils.hasText((String)element.getAttribute(PREDICATE_ATTRIBUTE))) {
            HazelcastContinuousQueryInboundChannelAdapterParser.errorAttributeRequired(element, parserContext, PREDICATE_ATTRIBUTE);
        } else if (!StringUtils.hasText((String)element.getAttribute(CACHE_LISTENING_POLICY_ATTRIBUTE))) {
            HazelcastContinuousQueryInboundChannelAdapterParser.errorAttributeRequired(element, parserContext, CACHE_LISTENING_POLICY_ATTRIBUTE);
        }
        builder.addPropertyReference(OUTPUT_CHANNEL, channelName).addConstructorArgReference(element.getAttribute(CACHE_ATTRIBUTE)).addConstructorArgValue((Object)element.getAttribute(PREDICATE_ATTRIBUTE));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)CACHE_EVENTS_ATTRIBUTE, (String)CACHE_EVENT_TYPES);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)INCLUDE_VALUE_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)CACHE_LISTENING_POLICY_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
    }

    private static void errorAttributeRequired(Element element, ParserContext parserContext, String attribute) {
        parserContext.getReaderContext().error("'" + attribute + "' attribute is required.", (Object)element);
    }
}

