/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.leader;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.lock.FencedLock;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.util.Assert;

public class LeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    private static final LogAccessor logger = new LogAccessor(LeaderInitiator.class);
    private static final Context NULL_CONTEXT = new NullContext();
    private final Lock lock = new ReentrantLock();
    private final HazelcastInstance client;
    private final Candidate candidate;
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("Hazelcast-leadership-");
    private long heartBeatMillis = 500L;
    private long busyWaitMillis = 50L;
    private LeaderSelector leaderSelector;
    private LeaderEventPublisher leaderEventPublisher = new DefaultLeaderEventPublisher();
    private boolean autoStartup = true;
    private int phase;
    private volatile Future<Void> future;
    private boolean customPublisher = false;
    private volatile boolean running;
    private final Semaphore yieldSign = new Semaphore(0);

    public LeaderInitiator(HazelcastInstance client) {
        this(client, (Candidate)new DefaultCandidate());
    }

    public LeaderInitiator(HazelcastInstance client, Candidate candidate) {
        Assert.notNull((Object)client, (String)"'client' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.client = client;
        this.candidate = candidate;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"A 'taskExecutor' must not be null.");
        this.taskExecutor = taskExecutor;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        Assert.notNull((Object)leaderEventPublisher, (String)"'leaderEventPublisher' must not be null");
        this.leaderEventPublisher = leaderEventPublisher;
        this.customPublisher = true;
    }

    public void setHeartBeatMillis(long heartBeatMillis) {
        this.heartBeatMillis = heartBeatMillis;
    }

    public void setBusyWaitMillis(long busyWaitMillis) {
        this.busyWaitMillis = busyWaitMillis;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        if (!this.customPublisher) {
            this.leaderEventPublisher = new DefaultLeaderEventPublisher(applicationEventPublisher);
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return NULL_CONTEXT;
        }
        return this.leaderSelector.context;
    }

    public void start() {
        this.lock.lock();
        try {
            if (!this.running) {
                this.leaderSelector = new LeaderSelector();
                this.running = true;
                this.future = this.taskExecutor.submit((Callable)this.leaderSelector);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.running) {
                this.running = false;
                if (this.future != null) {
                    this.future.cancel(true);
                }
                this.future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() {
        this.stop();
    }

    FencedLock getLock() {
        CPSubsystem cpSubSystem = this.client.getCPSubsystem();
        FencedLock lock = cpSubSystem.getLock(this.candidate.getRole());
        logger.debug((CharSequence)LogMessage.format((String)"Use lock groupId '%s', lock count '%s'", (Object)lock.getGroupId(), (Object)lock.getLockCount()));
        return lock;
    }

    protected class LeaderSelector
    implements Callable<Void> {
        protected final HazelcastContext context;
        protected final String role;
        private volatile boolean leader;

        protected LeaderSelector() {
            this.context = new HazelcastContext();
            this.role = LeaderInitiator.this.candidate.getRole();
            this.leader = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() {
            try {
                while (LeaderInitiator.this.isRunning()) {
                    try {
                        logger.trace(() -> "Am I the leader (" + LeaderInitiator.this.candidate.getRole() + ")? " + this.leader);
                        if (LeaderInitiator.this.getLock().isLockedByCurrentThread()) {
                            if (!this.leader) {
                                this.leader = true;
                            }
                            if (!LeaderInitiator.this.yieldSign.tryAcquire(LeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS)) continue;
                            this.revokeLeadership();
                            Thread.sleep(LeaderInitiator.this.busyWaitMillis);
                            continue;
                        }
                        boolean acquired = LeaderInitiator.this.getLock().tryLock(LeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS);
                        if (acquired && !this.leader) {
                            this.leader = true;
                            this.handleGranted();
                        }
                        if (acquired || !this.leader) continue;
                        this.revokeLeadership();
                    }
                    catch (Exception ex) {
                        this.revokeLeadership();
                        if (LeaderInitiator.this.isRunning()) {
                            try {
                                Thread.sleep(LeaderInitiator.this.busyWaitMillis);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        logger.debug((Throwable)ex, () -> "Error acquiring the lock for " + String.valueOf(this.context) + ". " + (LeaderInitiator.this.isRunning() ? "Retrying..." : ""));
                    }
                }
                return null;
            }
            finally {
                this.revokeLeadership();
            }
        }

        private void revokeLeadership() {
            if (this.leader) {
                this.leader = false;
                try {
                    LeaderInitiator.this.getLock().unlock();
                }
                catch (Exception e1) {
                    logger.warn((Throwable)e1, () -> "Could not unlock - treat as broken " + String.valueOf(this.context) + ". Revoking " + (LeaderInitiator.this.isRunning() ? " and retrying..." : "..."));
                }
                this.handleRevoked();
            }
        }

        private void handleGranted() throws InterruptedException {
            LeaderInitiator.this.candidate.onGranted((Context)this.context);
            if (LeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)this.context, this.role);
                }
                catch (Exception ex) {
                    logger.warn((Throwable)ex, (CharSequence)"Error publishing OnGranted event.");
                }
            }
        }

        private void handleRevoked() {
            LeaderInitiator.this.candidate.onRevoked((Context)this.context);
            if (LeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)this.context, this.role);
                }
                catch (Exception ex) {
                    logger.warn((Throwable)ex, (CharSequence)"Error publishing OnRevoked event.");
                }
            }
        }
    }

    protected class HazelcastContext
    implements Context {
        protected HazelcastContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.leaderSelector.leader;
        }

        public void yield() {
            if (this.isLeader()) {
                LeaderInitiator.this.yieldSign.release();
            }
        }

        public String getRole() {
            return LeaderInitiator.this.candidate.getRole();
        }

        public String toString() {
            return "HazelcastContext{role=" + LeaderInitiator.this.candidate.getRole() + ", id=" + LeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    private static final class NullContext
    implements Context {
        private NullContext() {
        }

        public boolean isLeader() {
            return false;
        }

        public void yield() {
        }
    }
}

