/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.hazelcast.outbound.HazelcastCacheWritingMessageHandler;
import org.w3c.dom.Element;

public class HazelcastOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    private static final String CACHE_ATTRIBUTE = "cache";
    private static final String CACHE_EXPRESSION_ATTRIBUTE = "cache-expression";
    private static final String KEY_EXPRESSION_ATTRIBUTE = "key-expression";
    private static final String EXTRACT_PAYLOAD_ATTRIBUTE = "extract-payload";
    private static final String DISTRIBUTED_OBJECT = "distributedObject";

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinition keyExpressionDef;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HazelcastCacheWritingMessageHandler.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)CACHE_ATTRIBUTE, (String)DISTRIBUTED_OBJECT);
        BeanDefinition cacheExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)CACHE_EXPRESSION_ATTRIBUTE, (Element)element);
        if (cacheExpressionDef != null) {
            builder.addPropertyValue("cacheExpression", (Object)cacheExpressionDef);
        }
        if ((keyExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)KEY_EXPRESSION_ATTRIBUTE, (Element)element)) != null) {
            builder.addPropertyValue("keyExpression", (Object)keyExpressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)EXTRACT_PAYLOAD_ATTRIBUTE);
        return builder.getBeanDefinition();
    }
}

