/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.Binding;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.transform.CompileStatic;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.groovy.BindingOverwriteGroovyObjectCustomizerDecorator;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GroovyScriptExecutingMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object>
implements InitializingBean {
    private final VariableBindingGroovyObjectCustomizerDecorator customizerDecorator = new VariableBindingGroovyObjectCustomizerDecorator();
    private final Lock scriptLock = new ReentrantLock();
    private final ScriptSource scriptSource;
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader(ClassUtils.getDefaultClassLoader());
    private boolean compileStatic;
    private @Nullable CompilerConfiguration compilerConfiguration;
    private volatile Class<?> scriptClass;

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
        this.scriptSource = scriptSource;
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizerDecorator.setCustomizer(customizer);
    }

    public void setCompileStatic(boolean compileStatic) {
        this.compileStatic = compileStatic;
    }

    public void setCompilerConfiguration(CompilerConfiguration compilerConfiguration) {
        this.compilerConfiguration = compilerConfiguration;
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        return this.scriptSource;
    }

    public void afterPropertiesSet() {
        CompilerConfiguration compilerConfig;
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).ignoreDependencyType(MetaClass.class);
        }
        if (this.compilerConfiguration == null && this.compileStatic) {
            compilerConfig = new CompilerConfiguration();
            compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(CompileStatic.class)});
        } else {
            compilerConfig = this.compilerConfiguration;
        }
        this.groovyClassLoader = new GroovyClassLoader(this.getBeanClassLoader(), compilerConfig);
    }

    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) {
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        this.parseScriptIfNecessary(scriptSource);
        Object result = this.execute(variables);
        return result instanceof GString ? result.toString() : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseScriptIfNecessary(ScriptSource scriptSource) {
        block6: {
            if (this.scriptClass == null || scriptSource.isModified()) {
                this.scriptLock.lock();
                try {
                    if (this.scriptClass != null && !scriptSource.isModified()) break block6;
                    String className = scriptSource.suggestedClassName();
                    try {
                        String scriptAsString = scriptSource.getScriptAsString();
                        this.scriptClass = StringUtils.hasText((String)className) ? this.groovyClassLoader.parseClass(scriptAsString, className) : this.groovyClassLoader.parseClass(scriptAsString);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                finally {
                    this.scriptLock.unlock();
                }
            }
        }
    }

    private Object execute(Map<String, Object> variables) throws ScriptCompilationException {
        GroovyObject goo = (GroovyObject)BeanUtils.instantiateClass(this.scriptClass);
        BindingOverwriteGroovyObjectCustomizerDecorator groovyObjectCustomizer = new BindingOverwriteGroovyObjectCustomizerDecorator(new BeanFactoryFallbackBinding(variables));
        groovyObjectCustomizer.setCustomizer(this.customizerDecorator);
        if (goo instanceof Script) {
            ((VariableBindingGroovyObjectCustomizerDecorator)groovyObjectCustomizer).customize(goo);
            return ((Script)goo).run();
        }
        return goo;
    }

    private final class BeanFactoryFallbackBinding
    extends Binding {
        BeanFactoryFallbackBinding(Map<?, ?> variables) {
            super(variables);
        }

        public Object getVariable(String name) {
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException missingPropertyException) {
                BeanFactory beanFactory = GroovyScriptExecutingMessageProcessor.this.getBeanFactory();
                if (beanFactory == null) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
                try {
                    return beanFactory.getBean(name);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
        }
    }
}

