/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.filters;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.filters.AbstractPersistentAcceptOnceFileListFilter;
import org.springframework.integration.ftp.session.EnhancedFTPFile;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.StringUtils;

public class FtpPersistentAcceptOnceFileListFilter
extends AbstractPersistentAcceptOnceFileListFilter<FTPFile> {
    public FtpPersistentAcceptOnceFileListFilter(ConcurrentMetadataStore store, String prefix) {
        super(store, prefix);
    }

    protected long modified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }

    protected String fileName(FTPFile file) {
        EnhancedFTPFile enhancedFTPFile;
        String longFileName;
        if (file instanceof EnhancedFTPFile && StringUtils.hasText((String)(longFileName = (enhancedFTPFile = (EnhancedFTPFile)file).getLongFileName()))) {
            return longFileName;
        }
        return file.getName();
    }

    protected boolean isDirectory(FTPFile file) {
        return file.isDirectory();
    }
}

