/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.FtpSession;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractFtpSessionFactory<T extends FTPClient>
implements SessionFactory<FTPFile> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FTPClientConfig config;
    private String username;
    private String host;
    private String password;
    private int port = 21;
    private int bufferSize = 2048;
    private int clientMode = 0;
    private int fileType = 2;
    private String controlEncoding = "ISO-8859-1";
    private Integer connectTimeout;
    private Integer defaultTimeout;
    private Integer dataTimeout;

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public void setControlEncoding(String controlEncoding) {
        Assert.hasText((String)controlEncoding, (String)"'controlEncoding' must not be empty");
        this.controlEncoding = controlEncoding;
    }

    public void setConfig(FTPClientConfig config) {
        Assert.notNull((Object)config, (String)"'config' must not be null");
        this.config = config;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setHost(String host) {
        Assert.hasText((String)host, (String)"'host' must not be empty");
        this.host = host;
    }

    public void setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port number should be > 0");
        this.port = port;
    }

    public void setUsername(String user) {
        Assert.hasText((String)user, (String)"'user' should be a nonempty string");
        this.username = user;
    }

    public void setPassword(String pass) {
        Assert.notNull((Object)pass, (String)"password should not be null");
        this.password = pass;
    }

    public void setClientMode(int clientMode) {
        Assert.isTrue((clientMode == 0 || clientMode == 2 ? 1 : 0) != 0, (String)("Only local modes are supported. Was: " + clientMode));
        this.clientMode = clientMode;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    public FtpSession getSession() {
        try {
            return new FtpSession((FTPClient)this.createClient());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create FTPClient", e);
        }
    }

    private T createClient() throws IOException {
        T client = this.createClientInstance();
        Assert.notNull(client, (String)"client must not be null");
        client.configure(this.config);
        Assert.hasText((String)this.username, (String)"username is required");
        if (this.connectTimeout != null) {
            client.setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.defaultTimeout != null) {
            client.setDefaultTimeout(this.defaultTimeout.intValue());
        }
        if (this.dataTimeout != null) {
            client.setDataTimeout(Duration.ofMillis(this.dataTimeout.intValue()));
        }
        client.setControlEncoding(this.controlEncoding);
        this.postProcessClientBeforeConnect(client);
        client.connect(this.host, this.port);
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new MessagingException("Connecting to server [" + this.host + ":" + this.port + "] failed. Please check the connection.");
        }
        this.logger.debug((Object)("Connected to server [" + this.host + ":" + this.port + "]"));
        if (!client.login(this.username, this.password)) {
            throw new IllegalStateException("Login failed. The response from the server is: " + client.getReplyString());
        }
        this.postProcessClientAfterConnect(client);
        this.updateClientMode((FTPClient)client);
        client.setFileType(this.fileType);
        client.setBufferSize(this.bufferSize);
        return client;
    }

    private void updateClientMode(FTPClient client) {
        switch (this.clientMode) {
            case 0: {
                client.enterLocalActiveMode();
                break;
            }
            case 2: {
                client.enterLocalPassiveMode();
                break;
            }
            default: {
                throw new IllegalArgumentException("Only 'FTPClient.ACTIVE_LOCAL_DATA_CONNECTION_MODE' and 'FTPClient.PASSIVE_LOCAL_DATA_CONNECTION_MODE' are supported for 'clientMode'");
            }
        }
    }

    protected abstract T createClientInstance();

    protected void postProcessClientAfterConnect(T t) throws IOException {
    }

    protected void postProcessClientBeforeConnect(T client) throws IOException {
    }
}

