/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.amqp.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AmqpAcknowledgment;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.rabbitmq.client.RabbitAmqpUtils;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpMessageListener;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.acks.SimpleAcknowledgment;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;

record IntegrationRabbitAmqpMessageListener(NamedComponent amqpInboundEndpoint, BiConsumer<Message<?>, @Nullable org.springframework.amqp.core.Message> requestAction, AmqpHeaderMapper headerMapper, @Nullable MessageConverter messageConverter, @Nullable Collection<MessagePostProcessor> afterReceivePostProcessors) implements RabbitAmqpMessageListener
{
    public void onAmqpMessage(com.rabbitmq.client.amqp.Message amqpMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Consumer.Context context) {
        org.springframework.amqp.core.Message message = RabbitAmqpUtils.fromAmqpMessage((com.rabbitmq.client.amqp.Message)amqpMessage, (Consumer.Context)context);
        Message<?> messageToSend = this.toSpringMessage(message);
        try {
            this.requestAction.accept(messageToSend, message);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException(this.amqpInboundEndpoint.getComponentName() + ".onAmqpMessage() failed", (Throwable)ex, new org.springframework.amqp.core.Message[]{message});
        }
    }

    public void onMessageBatch(List<org.springframework.amqp.core.Message> messages) {
        SimpleAcknowledgment acknowledgmentCallback = null;
        ArrayList springMessages = new ArrayList(messages.size());
        for (org.springframework.amqp.core.Message message : messages) {
            Message<?> springMessage = this.toSpringMessage(message);
            if (acknowledgmentCallback == null) {
                acknowledgmentCallback = StaticMessageHeaderAccessor.getAcknowledgment(springMessage);
            }
            springMessages.add(springMessage);
        }
        Message messageToSend = MutableMessageBuilder.withPayload(springMessages).setHeader("acknowledgmentCallback", acknowledgmentCallback).build();
        try {
            this.requestAction.accept(messageToSend, null);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException(this.amqpInboundEndpoint.getComponentName() + ".onMessageBatch() failed", (Throwable)ex, (org.springframework.amqp.core.Message[])messages.toArray(org.springframework.amqp.core.Message[]::new));
        }
    }

    private Message<?> toSpringMessage(org.springframework.amqp.core.Message message) {
        if (this.afterReceivePostProcessors != null) {
            for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                message = processor.postProcessMessage(message);
            }
        }
        MessageProperties messageProperties = message.getMessageProperties();
        AmqpAcknowledgment amqpAcknowledgment = messageProperties.getAmqpAcknowledgment();
        AmqpAcknowledgmentCallback acknowledgmentCallback = null;
        if (amqpAcknowledgment != null) {
            acknowledgmentCallback = new AmqpAcknowledgmentCallback(amqpAcknowledgment);
        }
        Object payload = message;
        Map headers = null;
        if (this.messageConverter != null) {
            payload = this.messageConverter.fromMessage(message);
            headers = this.headerMapper.toHeadersFromRequest(messageProperties);
        }
        return ((MessageBuilder)((MessageBuilder)MessageBuilder.withPayload((Object)payload).copyHeaders(headers)).setHeader("acknowledgmentCallback", (Object)acknowledgmentCallback)).build();
    }

    public void onMessage(org.springframework.amqp.core.Message message) {
        throw new UnsupportedOperationException("The 'IntegrationRabbitAmqpMessageListener' does not implement 'onMessage()'");
    }

    record AmqpAcknowledgmentCallback(AmqpAcknowledgment delegate) implements AcknowledgmentCallback
    {
        public void acknowledge(AcknowledgmentCallback.Status status) {
            this.delegate.acknowledge(AmqpAcknowledgment.Status.valueOf((String)status.name()));
        }

        public boolean isAutoAck() {
            return false;
        }
    }
}

