/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.problem;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Problem {
    private static Problem EMPTY = new Problem();
    private final @Nullable URI type;
    private final @Nullable String title;
    private final @Nullable HttpStatus status;
    private final @Nullable String detail;
    private final @Nullable URI instance;

    @JsonCreator
    public Problem(@JsonProperty(value="type") @Nullable URI type, @JsonProperty(value="title") @Nullable String title, @JsonProperty(value="status") @Nullable Integer status, @JsonProperty(value="detail") @Nullable String detail, @JsonProperty(value="instance") @Nullable URI instance) {
        this(type, title, status == null ? null : HttpStatus.resolve((int)status), detail, instance);
    }

    protected Problem(@Nullable URI type, @Nullable String title, @Nullable HttpStatus status, @Nullable String detail, @Nullable URI instance) {
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
    }

    private Problem() {
        this(null, null, (HttpStatus)null, null, null);
    }

    public static Problem create() {
        return EMPTY;
    }

    public static <T> ExtendedProblem<T> create(T payload) {
        Assert.notNull(payload, (String)"Payload must not be null!");
        return EMPTY.withProperties(payload);
    }

    public static Problem statusOnly(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus must not be null!");
        return new Problem(URI.create("about:blank"), status.getReasonPhrase(), status, null, null);
    }

    public Problem withType(@Nullable URI type) {
        return this.type == type ? this : new Problem(type, this.title, this.status, this.detail, this.instance);
    }

    public Problem withTitle(@Nullable String title) {
        return this.title == title ? this : new Problem(this.type, title, this.status, this.detail, this.instance);
    }

    public Problem withStatus(@Nullable HttpStatus status) {
        return this.status == status ? this : new Problem(this.type, this.title, status, this.detail, this.instance);
    }

    public Problem withDetail(@Nullable String detail) {
        return this.detail == detail ? this : new Problem(this.type, this.title, this.status, detail, this.instance);
    }

    public Problem withInstance(@Nullable URI instance) {
        return this.instance == instance ? this : new Problem(this.type, this.title, this.status, this.detail, instance);
    }

    public <T> ExtendedProblem<T> withProperties(T payload) {
        return new ExtendedProblem<T>(this.type, this.title, this.status, this.detail, this.instance, payload);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Consumer<Map<String, Object>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        consumer.accept(map);
        return this.withProperties((Map<String, Object>)map);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Map<String, Object> properties) {
        Assert.notNull(properties, (String)"Properties must not be null!");
        return new ExtendedProblem<Map<String, Object>>(this.type, this.title, this.status, this.detail, this.instance, properties);
    }

    @JsonProperty
    public @Nullable URI getType() {
        return this.type;
    }

    @JsonProperty
    public @Nullable String getTitle() {
        return this.title;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable Integer getStatusAsInteger() {
        return this.status != null ? Integer.valueOf(this.status.value()) : null;
    }

    @JsonIgnore
    public @Nullable HttpStatus getStatus() {
        return this.status;
    }

    @JsonProperty
    public @Nullable String getDetail() {
        return this.detail;
    }

    @JsonProperty
    public @Nullable URI getInstance() {
        return this.instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && Objects.equals(this.status, problem.status) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.instance, problem.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance);
    }

    public String toString() {
        return "Problem(type=" + String.valueOf(this.type) + ", title=" + this.title + ", status=" + String.valueOf(this.status) + ", detail=" + this.detail + ", instance=" + String.valueOf(this.instance) + ")";
    }

    public static final class ExtendedProblem<T>
    extends Problem {
        private @Nullable T extendedProperties;

        @JsonCreator
        ExtendedProblem(@JsonProperty @Nullable URI type, @JsonProperty @Nullable String title, @JsonProperty @Nullable Integer status, @JsonProperty @Nullable String detail, @JsonProperty @Nullable URI instance, @JsonProperty @Nullable T extendedProperties) {
            super(type, title, status, detail, instance);
            this.extendedProperties = extendedProperties;
        }

        ExtendedProblem(@Nullable URI type, @Nullable String title, @Nullable HttpStatus status, @Nullable String detail, @Nullable URI instance, @Nullable T extendedProperties) {
            super(type, title, status, detail, instance);
            this.extendedProperties = extendedProperties;
        }

        public ExtendedProblem(T extendedProperties) {
            this.extendedProperties = extendedProperties;
        }

        @Override
        public ExtendedProblem<T> withType(@Nullable URI type) {
            return new ExtendedProblem<T>(type, this.getTitle(), this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withTitle(@Nullable String title) {
            return new ExtendedProblem<T>(this.getType(), title, this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withStatus(@Nullable HttpStatus status) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), status, this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withDetail(@Nullable String detail) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), detail, this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withInstance(@Nullable URI instance) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), this.getDetail(), instance, this.extendedProperties);
        }

        @JsonIgnore
        public T getProperties() {
            return Objects.requireNonNull(this.extendedProperties);
        }

        public <S> ExtendedProblem<S> withProperties(S payload) {
            return super.withProperties(payload);
        }

        @JsonUnwrapped
        @Nullable T getExtendedProperties() {
            return Map.class.isInstance(this.extendedProperties) ? null : (T)this.extendedProperties;
        }

        @JsonAnyGetter
        @Nullable Map<String, Object> getPropertiesAsMap() {
            return Map.class.isInstance(this.extendedProperties) ? (Map)this.extendedProperties : null;
        }

        @JsonAnySetter
        void setPropertiesAsMap(String key, Object value) {
            if (this.extendedProperties != null && !Map.class.isInstance(this.extendedProperties)) {
                return;
            }
            this.getOrInitAsMap().put(key, value);
        }

        private Map<String, Object> getOrInitAsMap() {
            if (this.extendedProperties == null) {
                this.extendedProperties = new LinkedHashMap();
            }
            return (Map)this.extendedProperties;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtendedProblem)) {
                return false;
            }
            ExtendedProblem that = (ExtendedProblem)o;
            if (!super.equals(that)) {
                return false;
            }
            return Objects.equals(this.extendedProperties, that.extendedProperties);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.extendedProperties);
        }

        @Override
        public String toString() {
            return "Problem.ExtendedProblem(extendedProperties=" + String.valueOf(this.extendedProperties) + ")";
        }
    }
}

