/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.util.Assert;
import tools.jackson.databind.json.JsonMapper;

public class WebConverters {
    private static MediaType ANY_JSON = MediaType.parseMediaType((String)"application/*+json");
    private final List<HypermediaMappingInformation> infos;
    private final JsonMapper mapper;

    private WebConverters(JsonMapper mapper, List<HypermediaMappingInformation> mappingInformation) {
        this.mapper = mapper;
        this.infos = mappingInformation;
    }

    public static WebConverters of(JsonMapper mapper, List<HypermediaMappingInformation> mappingInformations) {
        Assert.notNull((Object)mapper, (String)"JsonMapper must not be null!");
        Assert.notNull(mappingInformations, (String)"Mapping information must not be null!");
        return new WebConverters(mapper, mappingInformations);
    }

    List<MediaType> getSupportedMediaTypes() {
        return this.infos.stream().flatMap(it -> it.getMediaTypes().stream()).collect(Collectors.toList());
    }

    public void augmentServer(List<HttpMessageConverter<?>> converters) {
        this.augment(converters, false);
    }

    public void augmentClient(List<HttpMessageConverter<?>> converters) {
        this.augment(converters, true);
    }

    private void augment(List<HttpMessageConverter<?>> converters, boolean includeGenericJsonTypes) {
        Assert.notNull(converters, (String)"HttpMessageConverters must not be null!");
        JacksonJsonHttpMessageConverter converter = converters.stream().filter(it -> JacksonJsonHttpMessageConverter.class.equals(it.getClass())).map(JacksonJsonHttpMessageConverter.class::cast).findFirst().orElseGet(() -> new JacksonJsonHttpMessageConverter(this.mapper));
        JsonMapper first = null;
        for (HypermediaMappingInformation info : this.infos) {
            Class<?> rootType = info.getRootType();
            JsonMapper configured = info.configureJsonMapper(this.mapper.rebuild()).build();
            if (first == null) {
                first = configured;
            }
            Map mappers = info.getMediaTypes().stream().distinct().collect(Collectors.toMap(Function.identity(), __ -> configured));
            converter.registerMappersForType(rootType, map -> map.putAll(mappers));
        }
        if (!includeGenericJsonTypes || this.infos.isEmpty()) {
            return;
        }
        Class<?> rootType = this.infos.get(0).getRootType();
        JsonMapper mapper = first;
        converter.registerMappersForType(rootType, map -> Stream.of(MediaType.APPLICATION_JSON, ANY_JSON).forEach(it -> map.put(it, mapper)));
    }
}

