/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.io.IOException;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.hateoas.aot.AotUtils;
import org.springframework.util.Assert;

class HypermediaTypesRuntimeHints
implements RuntimeHintsRegistrar {
    private static final TypeFilter HAS_JACKSON_SUPER_TYPE_FILTER = new JacksonSuperTypeFilter();
    private static final TypeFilter IS_JACKSON_ANNOTATION_PRESENT_FILTER = new JacksonAnnotationPresentFilter();
    private final String hypermediaPackage;

    HypermediaTypesRuntimeHints(String hypermediaPackage) {
        Assert.hasText((String)hypermediaPackage, (String)"Package must not be null or empty!");
        this.hypermediaPackage = hypermediaPackage;
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        AotUtils.registerTypesForReflection(this.hypermediaPackage, hints.reflection(), HAS_JACKSON_SUPER_TYPE_FILTER, IS_JACKSON_ANNOTATION_PRESENT_FILTER);
    }

    static class JacksonSuperTypeFilter
    extends AbstractTypeHierarchyTraversingFilter {
        private static final String JACKSON_PACKAGE = "tools.jackson";

        JacksonSuperTypeFilter() {
            super(true, true);
        }

        protected Boolean matchSuperClass(String superClassName) {
            return superClassName.startsWith(JACKSON_PACKAGE);
        }

        protected Boolean matchInterface(String interfaceName) {
            return interfaceName.startsWith(JACKSON_PACKAGE);
        }
    }

    static class JacksonAnnotationPresentFilter
    implements TypeFilter {
        private static final Predicate<String> IS_JACKSON_ANNOTATION = it -> it.startsWith("tools.jackson") || it.startsWith("com.fasterxml.jackson");

        JacksonAnnotationPresentFilter() {
        }

        public boolean match(MetadataReader reader, MetadataReaderFactory factory) throws IOException {
            AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
            return annotationMetadata.getAnnotationTypes().stream().anyMatch(IS_JACKSON_ANNOTATION) || annotationMetadata.getDeclaredMethods().stream().flatMap(it -> it.getAnnotations().stream()).map(MergedAnnotation::getType).map(Class::getName).anyMatch(IS_JACKSON_ANNOTATION);
        }
    }
}

