/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.hateoas.config.WebConverters;
import org.springframework.hateoas.config.WebMvcEntityLinksConfiguration;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorHandlerMethodReturnValueHandler;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.hateoas.server.mvc.UriComponentsContributor;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilderFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration(proxyBeanMethods=false)
@Import(value={WebMvcEntityLinksConfiguration.class})
class WebMvcHateoasConfiguration {
    WebMvcHateoasConfiguration() {
    }

    @Bean
    HypermediaWebMvcConfigurer hypermediaWebMvcConfigurer(WebConverters converters) {
        return new HypermediaWebMvcConfigurer(converters);
    }

    @Bean
    RepresentationModelProcessorInvoker representationModelProcessorInvoker(List<RepresentationModelProcessor<?>> processors) {
        return new RepresentationModelProcessorInvoker(processors);
    }

    @Bean
    static HypermediaRepresentationModelBeanProcessorPostProcessor hypermediaRepresentionModelProcessorConfigurator(ObjectProvider<RepresentationModelProcessorInvoker> invoker) {
        return new HypermediaRepresentationModelBeanProcessorPostProcessor(invoker);
    }

    @Bean
    WebMvcLinkBuilderFactory webMvcLinkBuilderFactory(ObjectProvider<UriComponentsContributor> contributors) {
        WebMvcLinkBuilderFactory factory = new WebMvcLinkBuilderFactory();
        factory.setUriComponentsContributors(contributors.stream().collect(Collectors.toList()));
        return factory;
    }

    static class HypermediaWebMvcConfigurer
    implements WebMvcConfigurer {
        private final @NonNull WebConverters hypermediaConverters;

        public HypermediaWebMvcConfigurer(WebConverters hypermediaConverters) {
            this.hypermediaConverters = hypermediaConverters;
        }

        public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
            this.hypermediaConverters.augmentServer(converters);
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)DummyInvocationUtilsCacheClearer.INSTANCE);
        }
    }

    static class HypermediaRepresentationModelBeanProcessorPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<RepresentationModelProcessorInvoker> invoker;

        public HypermediaRepresentationModelBeanProcessorPostProcessor(ObjectProvider<RepresentationModelProcessorInvoker> invoker) {
            this.invoker = invoker;
        }

        public @NonNull Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (RequestMappingHandlerAdapter.class.isInstance(bean)) {
                RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean;
                HandlerMethodReturnValueHandlerComposite delegate = new HandlerMethodReturnValueHandlerComposite();
                delegate.addHandlers(adapter.getReturnValueHandlers());
                RepresentationModelProcessorHandlerMethodReturnValueHandler handler = new RepresentationModelProcessorHandlerMethodReturnValueHandler((HandlerMethodReturnValueHandler)delegate, () -> (RepresentationModelProcessorInvoker)this.invoker.getObject());
                adapter.setReturnValueHandlers(Collections.singletonList(handler));
            }
            return bean;
        }
    }

    static enum DummyInvocationUtilsCacheClearer implements HandlerInterceptor
    {
        INSTANCE;


        public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
            DummyInvocationUtils.resetCache();
        }
    }
}

