/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.HypermediaMappingInformationComparator;
import org.springframework.hateoas.config.WebConverters;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.AnnotationLinkRelationProvider;
import org.springframework.hateoas.server.core.DefaultLinkRelationProvider;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.json.JsonMapper;

@Configuration(proxyBeanMethods=false)
@EnablePluginRegistries(value={LinkDiscoverer.class})
public class HateoasConfiguration {
    static String I18N_BASE_NAME = "rest-messages";
    static String I18N_DEFAULTS_BASE_NAME = "rest-default-messages";
    @Autowired
    private ApplicationContext context;

    @Bean
    public MessageResolver messageResolver() {
        return MessageResolver.of((MessageSource)this.lookupMessageSource());
    }

    @Bean
    WebConverters hypermediaWebMvcConverters(ObjectProvider<JsonMapper> mapper, List<HypermediaMappingInformation> information, Optional<HypermediaMappingInformationComparator> comparator) {
        comparator.ifPresent(information::sort);
        return WebConverters.of((JsonMapper)mapper.getIfUnique(JsonMapper::new), information);
    }

    @Bean
    LinkRelationProvider defaultRelProvider() {
        return ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null) ? new EvoInflectorLinkRelationProvider() : new DefaultLinkRelationProvider();
    }

    @Bean
    AnnotationLinkRelationProvider annotationRelProvider() {
        return new AnnotationLinkRelationProvider();
    }

    @Primary
    @Bean
    DelegatingLinkRelationProvider _relProvider(PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> relProviderPluginRegistry) {
        return new DelegatingLinkRelationProvider(relProviderPluginRegistry);
    }

    @Bean
    OrderAwarePluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> relProviderPluginRegistry(ListableBeanFactory beanFactory) {
        PluginRegistryFactoryBean factory = new PluginRegistryFactoryBean();
        factory.setBeanFactory((BeanFactory)beanFactory);
        factory.setType(LinkRelationProvider.class);
        factory.setExclusions(new Class[]{DelegatingLinkRelationProvider.class});
        return factory.getObject();
    }

    @Bean
    LinkDiscoverers linkDiscoverers(PluginRegistry<LinkDiscoverer, MediaType> discoverers) {
        return new LinkDiscoverers(discoverers);
    }

    private final @Nullable AbstractMessageSource lookupMessageSource() {
        List<Resource> candidates = this.loadResourceBundleResources(I18N_DEFAULTS_BASE_NAME, false);
        if (candidates.isEmpty() && this.loadResourceBundleResources(I18N_BASE_NAME, true).isEmpty()) {
            return null;
        }
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setResourceLoader((ResourceLoader)this.context);
        messageSource.setBasename("classpath:".concat(I18N_BASE_NAME));
        messageSource.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        if (!candidates.isEmpty()) {
            messageSource.setCommonMessages(this.loadProperties(candidates));
        }
        return messageSource;
    }

    private final @Nullable Properties loadProperties(List<Resource> sources) {
        PropertiesFactoryBean factory = new PropertiesFactoryBean();
        factory.setLocations(sources.toArray(new Resource[sources.size()]));
        try {
            factory.afterPropertiesSet();
            return factory.getObject();
        }
        catch (IOException o_O) {
            throw new IllegalStateException("Could not load default properties from resources!", o_O);
        }
    }

    private final List<Resource> loadResourceBundleResources(String baseName, boolean withWildcard) {
        try {
            return Arrays.stream(this.context.getResources(String.format("classpath:%s%s.properties", baseName, withWildcard ? "*" : ""))).filter(Resource::exists).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

