/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import java.io.InputStream;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.mediatype.uber.UberDocument;
import org.springframework.hateoas.mediatype.uber.UberJacksonModule;
import org.springframework.http.MediaType;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

public class UberLinkDiscoverer
implements LinkDiscoverer {
    private final JsonMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new UberJacksonModule())).build();

    UberLinkDiscoverer() {
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation rel, String representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation rel, InputStream representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    @Override
    public Links findLinksWithRel(LinkRelation rel, String representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    @Override
    public Links findLinksWithRel(LinkRelation rel, InputStream representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    public boolean supports(MediaType delimiter) {
        return delimiter.isCompatibleWith(MediaTypes.UBER_JSON);
    }

    private Links getLinks(String json) {
        return ((UberDocument)this.mapper.readValue(json, UberDocument.class)).getUber().getLinks();
    }

    private Links getLinks(InputStream stream) {
        return ((UberDocument)this.mapper.readValue(stream, UberDocument.class)).getUber().getLinks();
    }
}

