/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.springframework.lang.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
final class CollectionJsonData {
    @Nullable
    private final String name;
    @Nullable
    private final Object value;
    @Nullable
    private final String prompt;

    @JsonCreator
    CollectionJsonData(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="value") @Nullable Object value, @JsonProperty(value="prompt") @Nullable String prompt) {
        this.name = name;
        this.value = value;
        this.prompt = prompt;
    }

    CollectionJsonData() {
        this(null, null, null);
    }

    public CollectionJsonData withName(@Nullable String name) {
        return this.name == name ? this : new CollectionJsonData(name, this.value, this.prompt);
    }

    public CollectionJsonData withValue(@Nullable Object value) {
        return this.value == value ? this : new CollectionJsonData(this.name, value, this.prompt);
    }

    public CollectionJsonData withPrompt(@Nullable String prompt) {
        return this.prompt == prompt ? this : new CollectionJsonData(this.name, this.value, prompt);
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @JsonProperty
    @Nullable
    public String getPrompt() {
        return this.prompt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonData that = (CollectionJsonData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.prompt, that.prompt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.prompt);
    }

    public String toString() {
        return "CollectionJsonData(name=" + this.name + ", value=" + this.value + ", prompt=" + this.prompt + ")";
    }
}

