/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.http.MediaType;

@Configuration(proxyBeanMethods=false)
public class HalMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final LinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalConfiguration> halConfiguration;
    @Qualifier(value="messageResolver")
    private final MessageResolver resolver;
    private final AutowireCapableBeanFactory beanFactory;

    @Bean
    LinkDiscoverer halLinkDisocoverer() {
        return new HalLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return EnableHypermediaSupport.HypermediaType.HAL.getMediaTypes();
    }

    @Override
    public ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)new Jackson2HalModule.HalHandlerInstantiator(this.relProvider, (CurieProvider)this.curieProvider.getIfAvailable(() -> CurieProvider.NONE), this.resolver, (HalConfiguration)this.halConfiguration.getIfAvailable(HalConfiguration::new), this.beanFactory));
        return mapper;
    }

    @Generated
    public HalMediaTypeConfiguration(LinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, MessageResolver resolver, AutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halConfiguration = halConfiguration;
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }
}

