/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import lombok.Generated;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

public final class QueryParameter {
    private final String name;
    @Nullable
    private final String value;
    private final boolean required;

    public static QueryParameter of(MethodParameter parameter) {
        String name;
        MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)parameter.getParameter()).get(RequestParam.class);
        String string = name = annotation.isPresent() && annotation.hasNonDefaultValue("name") ? annotation.getString("name") : parameter.getParameterName();
        if (name == null || !StringUtils.hasText((String)name)) {
            throw new IllegalStateException(String.format("Couldn't determine parameter name for %s!", parameter));
        }
        boolean required = annotation.isPresent() && annotation.hasNonDefaultValue("required") ? annotation.getBoolean("required") : !Optional.class.equals((Object)parameter.getParameterType());
        return required ? QueryParameter.required(name) : QueryParameter.optional(name);
    }

    public static QueryParameter required(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new QueryParameter(name, null, true);
    }

    public static QueryParameter optional(String name) {
        return new QueryParameter(name, null, false);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean isRequired() {
        return this.required;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParameter)) {
            return false;
        }
        QueryParameter other = (QueryParameter)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isRequired() == other.isRequired();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "QueryParameter(name=" + this.getName() + ", value=" + this.getValue() + ", required=" + this.isRequired() + ")";
    }

    @Generated
    private QueryParameter(String name, @Nullable String value, boolean required) {
        this.name = name;
        this.value = value;
        this.required = required;
    }

    @NonNull
    @Generated
    public QueryParameter withValue(@Nullable String value) {
        return this.value == value ? this : new QueryParameter(this.name, value, this.required);
    }
}

