/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.reactive;

import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.reactive.ReactiveRepresentationModelAssembler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface SimpleReactiveRepresentationModelAssembler<T>
extends ReactiveRepresentationModelAssembler<T, EntityModel<T>> {
    @Override
    default public Mono<EntityModel<T>> toModel(T entity, ServerWebExchange exchange) {
        EntityModel<T> resource = EntityModel.of(entity);
        return Mono.just(this.addLinks(resource, exchange));
    }

    default public EntityModel<T> addLinks(EntityModel<T> resource, ServerWebExchange exchange) {
        return resource;
    }

    @Override
    default public Mono<CollectionModel<EntityModel<T>>> toCollectionModel(Flux<? extends T> entities, ServerWebExchange exchange) {
        return entities.flatMap(entity -> this.toModel(entity, exchange)).collectList().map(x$0 -> new CollectionModel(x$0, new Link[0])).map(it -> this.addLinks((CollectionModel<EntityModel<T>>)it, exchange));
    }

    default public CollectionModel<EntityModel<T>> addLinks(CollectionModel<EntityModel<T>> resources, ServerWebExchange exchange) {
        return resources;
    }
}

