/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.vnderrors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.core.Relation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonPropertyOrder(value={"message", "logref", "total", "_links", "_embedded"})
@JsonIgnoreProperties(ignoreUnknown=true)
@Deprecated
public class VndErrors
extends CollectionModel<VndError> {
    @Deprecated
    public static final String REL_HELP = "help";
    @Deprecated
    public static final String REL_DESCRIBES = "describes";
    @Deprecated
    public static final String REL_ABOUT = "about";
    private final List<VndError> errors;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String message;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Integer logref;

    public VndErrors() {
        this.errors = new ArrayList<VndError>();
        this.message = null;
        this.logref = null;
    }

    public VndErrors(String logref, String message, Link ... links) {
        this(new VndError(message, null, (Integer)Integer.parseInt(logref), links), new VndError[0]);
    }

    public VndErrors(VndError error, VndError ... errors) {
        Assert.notNull((Object)error, (String)"Error must not be null");
        this.errors = new ArrayList<VndError>();
        this.errors.add(error);
        Collections.addAll(this.errors, errors);
        this.message = null;
        this.logref = null;
    }

    @JsonCreator
    public VndErrors(@JsonProperty(value="_embedded") List<VndError> errors, @JsonProperty(value="message") String message, @JsonProperty(value="logref") Integer logref, @JsonProperty(value="_links") Links links) {
        Assert.notNull(errors, (String)"Errors must not be null!");
        Assert.notEmpty(errors, (String)"Errors must not be empty!");
        this.errors = errors;
        this.message = message;
        this.logref = logref;
        if (links != null && !links.isEmpty()) {
            this.add(links);
        }
    }

    public VndErrors withMessage(String message) {
        return new VndErrors(this.errors, message, this.logref, this.getLinks());
    }

    public VndErrors withLogref(Integer logref) {
        return new VndErrors(this.errors, this.message, logref, this.getLinks());
    }

    public VndErrors withErrors(List<VndError> errors) {
        Assert.notNull(errors, (String)"errors must not be null!");
        Assert.notEmpty(errors, (String)"errors must not empty!");
        return new VndErrors(errors, this.message, this.logref, this.getLinks());
    }

    public VndErrors withError(VndError error) {
        this.errors.add(error);
        return new VndErrors(this.errors, this.message, this.logref, this.getLinks());
    }

    public VndErrors withLink(Link link) {
        this.add(link);
        return new VndErrors(this.errors, this.message, this.logref, this.getLinks());
    }

    public VndErrors withLinks(Link ... links) {
        this.add(links);
        return new VndErrors(this.errors, this.message, this.logref, this.getLinks());
    }

    @Override
    public Collection<VndError> getContent() {
        return this.errors;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getTotal() {
        List<VndError> errors = this.errors;
        if (errors == null) {
            return null;
        }
        return this.errors.size() > 1 ? Integer.valueOf(this.errors.size()) : null;
    }

    @Deprecated
    public VndErrors add(VndError error) {
        return this.withError(error);
    }

    @Override
    public Iterator<VndError> iterator() {
        return this.errors.iterator();
    }

    @Override
    public String toString() {
        return String.format("VndErrors[%s]", StringUtils.collectionToCommaDelimitedString(this.errors));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VndErrors)) {
            return false;
        }
        VndErrors other = (VndErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<VndError> this$errors = this.errors;
        List<VndError> other$errors = other.errors;
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Integer this$logref = this.getLogref();
        Integer other$logref = other.getLogref();
        return !(this$logref == null ? other$logref != null : !((Object)this$logref).equals(other$logref));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VndErrors;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<VndError> $errors = this.errors;
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Integer $logref = this.getLogref();
        result = result * 59 + ($logref == null ? 43 : ((Object)$logref).hashCode());
        return result;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getLogref() {
        return this.logref;
    }

    @JsonPropertyOrder(value={"message", "path", "logref"})
    @Relation(collectionRelation="errors")
    @Deprecated
    public static class VndError
    extends RepresentationModel<VndError> {
        private final String message;
        private final String path;
        private final Integer logref;

        @JsonCreator
        public VndError(@JsonProperty(value="message") String message, @JsonProperty(value="path") String path, @JsonProperty(value="logref") Integer logref, @JsonProperty(value="_links") List<Link> links) {
            Assert.hasText((String)message, (String)"Message must not be null or empty!");
            this.message = message;
            this.path = path;
            this.logref = logref;
            this.add(links);
        }

        public VndError(String message, String path, Integer logref, Link ... link) {
            this(message, path, logref, Arrays.asList(link));
        }

        @Deprecated
        public VndError(String logref, String message, Link ... links) {
            this(message, null, (Integer)Integer.parseInt(logref), Arrays.asList(links));
        }

        @Override
        public String toString() {
            return String.format("VndError[logref: %s, message: %s, links: [%s]]", this.logref, this.message, this.getLinks().toString());
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VndError)) {
                return false;
            }
            VndError other = (VndError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Integer this$logref = this.getLogref();
            Integer other$logref = other.getLogref();
            return !(this$logref == null ? other$logref != null : !((Object)this$logref).equals(other$logref));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VndError;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Integer $logref = this.getLogref();
            result = result * 59 + ($logref == null ? 43 : ((Object)$logref).hashCode());
            return result;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Generated
        public String getPath() {
            return this.path;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Generated
        public Integer getLogref() {
            return this.logref;
        }
    }
}

