/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.problem;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Problem {
    private static Problem EMPTY = new Problem();
    @Nullable
    private final URI type;
    @Nullable
    private final String title;
    @Nullable
    private final HttpStatus status;
    @Nullable
    private final String detail;
    @Nullable
    private final URI instance;

    @JsonCreator
    public Problem(@JsonProperty(value="type") URI type, @JsonProperty(value="title") String title, @JsonProperty(value="status") int status, @JsonProperty(value="detail") String detail, @JsonProperty(value="instance") URI instance) {
        this(type, title, HttpStatus.resolve((int)status), detail, instance);
    }

    public static Problem create() {
        return EMPTY;
    }

    public static <T> ExtendedProblem<T> create(T payload) {
        Assert.notNull(payload, (String)"Payload must not be null!");
        return EMPTY.withProperties(payload);
    }

    public static Problem statusOnly(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus must not be null!");
        return new Problem(URI.create("about:blank"), status.getReasonPhrase(), status, null, null);
    }

    public <T> ExtendedProblem<T> withProperties(T payload) {
        return new ExtendedProblem<T>(this.type, this.title, this.status, this.detail, this.instance, payload);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Consumer<Map<String, Object>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        consumer.accept(map);
        return this.withProperties((Map<String, Object>)map);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Map<String, Object> properties) {
        Assert.notNull(properties, (String)"Properties must not be null!");
        return new ExtendedProblem<Map<String, Object>>(this.type, this.title, this.status, this.detail, this.instance, properties);
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Integer getStatusAsInteger() {
        return this.status != null ? Integer.valueOf(this.status.value()) : null;
    }

    @JsonProperty
    @Nullable
    @Generated
    public URI getType() {
        return this.type;
    }

    @JsonProperty
    @Nullable
    @Generated
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    @Nullable
    @Generated
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty
    @Nullable
    @Generated
    public URI getInstance() {
        return this.instance;
    }

    @Generated
    public Problem withType(@Nullable URI type) {
        return this.type == type ? this : new Problem(type, this.title, this.status, this.detail, this.instance);
    }

    @Generated
    public Problem withTitle(@Nullable String title) {
        return this.title == title ? this : new Problem(this.type, title, this.status, this.detail, this.instance);
    }

    @Generated
    public Problem withStatus(@Nullable HttpStatus status) {
        return this.status == status ? this : new Problem(this.type, this.title, status, this.detail, this.instance);
    }

    @Generated
    public Problem withDetail(@Nullable String detail) {
        return this.detail == detail ? this : new Problem(this.type, this.title, this.status, detail, this.instance);
    }

    @Generated
    public Problem withInstance(@Nullable URI instance) {
        return this.instance == instance ? this : new Problem(this.type, this.title, this.status, this.detail, instance);
    }

    @Generated
    public String toString() {
        return "Problem(type=" + this.getType() + ", title=" + this.getTitle() + ", status=" + this.getStatus() + ", detail=" + this.getDetail() + ", instance=" + this.getInstance() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$type = this.getType();
        URI other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        URI this$instance = this.getInstance();
        URI other$instance = other.getInstance();
        return !(this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Problem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        URI $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        return result;
    }

    @Generated
    protected Problem() {
        this.type = null;
        this.title = null;
        this.status = null;
        this.detail = null;
        this.instance = null;
    }

    @Generated
    private Problem(@Nullable URI type, @Nullable String title, @Nullable HttpStatus status, @Nullable String detail, @Nullable URI instance) {
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
    }

    @JsonIgnore
    @Nullable
    @Generated
    public HttpStatus getStatus() {
        return this.status;
    }

    public static final class ExtendedProblem<T>
    extends Problem {
        private T extendedProperties;

        ExtendedProblem(@Nullable URI type, @Nullable String title, @Nullable HttpStatus status, @Nullable String detail, @Nullable URI instance, @Nullable T properties) {
            super(type, title, status, detail, instance);
            this.extendedProperties = properties;
        }

        @Override
        public ExtendedProblem<T> withType(@Nullable URI type) {
            return new ExtendedProblem<T>(type, this.getTitle(), this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withTitle(@Nullable String title) {
            return new ExtendedProblem<T>(this.getType(), title, this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withDetail(@Nullable String detail) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), detail, this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withInstance(@Nullable URI instance) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), this.getDetail(), instance, this.extendedProperties);
        }

        @JsonIgnore
        public T getProperties() {
            return this.extendedProperties;
        }

        public <S> ExtendedProblem<S> withProperties(S payload) {
            return super.withProperties(payload);
        }

        @Nullable
        @JsonUnwrapped
        T getExtendedProperties() {
            return Map.class.isInstance(this.extendedProperties) ? null : (T)this.extendedProperties;
        }

        @Nullable
        @JsonAnyGetter
        Map<String, Object> getPropertiesAsMap() {
            return Map.class.isInstance(this.extendedProperties) ? (Map)this.extendedProperties : null;
        }

        @JsonAnySetter
        void setPropertiesAsMap(String key, Object value) {
            this.getOrInitAsMap().put(key, value);
        }

        private Map<String, Object> getOrInitAsMap() {
            if (this.extendedProperties == null) {
                this.extendedProperties = new LinkedHashMap();
            }
            return (Map)this.extendedProperties;
        }

        @Override
        @Generated
        public String toString() {
            return "Problem.ExtendedProblem(extendedProperties=" + this.getExtendedProperties() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtendedProblem)) {
                return false;
            }
            ExtendedProblem other = (ExtendedProblem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            T this$extendedProperties = this.getExtendedProperties();
            T other$extendedProperties = other.getExtendedProperties();
            return !(this$extendedProperties == null ? other$extendedProperties != null : !this$extendedProperties.equals(other$extendedProperties));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExtendedProblem;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            T $extendedProperties = this.getExtendedProperties();
            result = result * 59 + ($extendedProperties == null ? 43 : $extendedProperties.hashCode());
            return result;
        }

        @Generated
        private ExtendedProblem() {
        }
    }
}

