/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RepresentationModel<T extends RepresentationModel<? extends T>> {
    private final List<Link> links;

    public RepresentationModel() {
        this.links = new ArrayList<Link>();
    }

    public RepresentationModel(Link initialLink) {
        Assert.notNull((Object)initialLink, (String)"initialLink must not be null!");
        this.links = new ArrayList<Link>();
        this.links.add(initialLink);
    }

    public RepresentationModel(List<Link> initialLinks) {
        Assert.notNull(initialLinks, (String)"initialLinks must not be null!");
        this.links = new ArrayList<Link>();
        this.links.addAll(initialLinks);
    }

    public T add(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        this.links.add(link);
        return (T)this;
    }

    public T add(Iterable<Link> links) {
        Assert.notNull(links, (String)"Given links must not be null!");
        links.forEach(this::add);
        return (T)this;
    }

    public T add(Link ... links) {
        Assert.notNull((Object)links, (String)"Given links must not be null!");
        this.add(Arrays.asList(links));
        return (T)this;
    }

    public T addIf(boolean guard, Supplier<Link> link) {
        if (guard) {
            this.add(link.get());
        }
        return (T)this;
    }

    public T addAllIf(boolean guard, Supplier<? extends Iterable<Link>> links) {
        if (guard) {
            this.add(links.get());
        }
        return (T)this;
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel).isPresent();
    }

    public boolean hasLink(LinkRelation rel) {
        return this.hasLink(rel.value());
    }

    @JsonProperty(value="links")
    public Links getLinks() {
        return Links.of(this.links);
    }

    public T removeLinks() {
        this.links.clear();
        return (T)this;
    }

    public Optional<Link> getLink(String relation) {
        return this.getLink(LinkRelation.of(relation));
    }

    public Optional<Link> getLink(LinkRelation relation) {
        return this.links.stream().filter(it -> it.hasRel(relation)).findFirst();
    }

    public Link getRequiredLink(String relation) {
        return this.getLink(relation).orElseThrow(() -> new IllegalArgumentException(String.format("No link with rel %s found!", relation)));
    }

    public Link getRequiredLink(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.getRequiredLink(relation.value());
    }

    public List<Link> getLinks(String relation) {
        Assert.hasText((String)relation, (String)"Link relation must not be null or empty!");
        return this.links.stream().filter(link -> link.hasRel(relation)).collect(Collectors.toList());
    }

    public List<Link> getLinks(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.getLinks(relation.value());
    }

    public String toString() {
        return String.format("links: %s", this.links.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        RepresentationModel that = (RepresentationModel)obj;
        return this.getLinks().equals(that.getLinks());
    }

    public int hashCode() {
        return this.links.hashCode();
    }
}

